/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop.mapreduce;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.mapreduce.hadoop.IDConverter;
import org.apache.tez.mapreduce.processor.MRTaskReporter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobContextImpl
implements JobContext {
    protected final JobConf conf;
    private TezDAGID dagId;
    protected final Credentials credentials;
    private Progressable progress;

    public JobContextImpl(Configuration conf, TezDAGID dagId) {
        this(conf, dagId, (Progressable)MRTaskReporter.NULL);
    }

    public JobContextImpl(Configuration conf, TezDAGID dagId, Progressable progress) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.dagId = dagId;
        this.credentials = this.conf.getCredentials();
        this.progress = progress;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public JobID getJobID() {
        return IDConverter.toMRJobId(this.dagId);
    }

    public void setJobID(JobID jobId) {
        this.dagId = IDConverter.fromMRJobId(jobId);
    }

    public int getNumReduceTasks() {
        return this.conf.getNumReduceTasks();
    }

    public Path getWorkingDirectory() throws IOException {
        return this.conf.getWorkingDirectory();
    }

    public Class<?> getOutputKeyClass() {
        return this.conf.getOutputKeyClass();
    }

    public Class<?> getOutputValueClass() {
        return this.conf.getOutputValueClass();
    }

    public Class<?> getMapOutputKeyClass() {
        return this.conf.getMapOutputKeyClass();
    }

    public Class<?> getMapOutputValueClass() {
        return this.conf.getMapOutputValueClass();
    }

    public String getJobName() {
        return this.conf.getJobName();
    }

    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.inputformat.class", TextInputFormat.class);
    }

    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.map.class", Mapper.class);
    }

    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.combine.class", null);
    }

    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.reduce.class", Reducer.class);
    }

    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.outputformat.class", TextOutputFormat.class);
    }

    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.partitioner.class", HashPartitioner.class);
    }

    public RawComparator<?> getSortComparator() {
        return this.conf.getOutputKeyComparator();
    }

    public String getJar() {
        return this.conf.getJar();
    }

    public RawComparator<?> getCombinerKeyGroupingComparator() {
        return this.getSortComparator();
    }

    public RawComparator<?> getGroupingComparator() {
        return this.conf.getOutputValueGroupingComparator();
    }

    public boolean getJobSetupCleanupNeeded() {
        return this.conf.getBoolean("mapreduce.job.committer.setup.cleanup.needed", true);
    }

    public boolean getTaskCleanupNeeded() {
        return this.conf.getBoolean("mapreduce.job.committer.task.cleanup.needed", true);
    }

    public boolean getSymlink() {
        return DistributedCache.getSymlink((Configuration)this.conf);
    }

    public Path[] getArchiveClassPaths() {
        return DistributedCache.getArchiveClassPaths((Configuration)this.conf);
    }

    public URI[] getCacheArchives() throws IOException {
        return DistributedCache.getCacheArchives((Configuration)this.conf);
    }

    public URI[] getCacheFiles() throws IOException {
        return DistributedCache.getCacheFiles((Configuration)this.conf);
    }

    public Path[] getLocalCacheArchives() throws IOException {
        return DistributedCache.getLocalCacheArchives((Configuration)this.conf);
    }

    public Path[] getLocalCacheFiles() throws IOException {
        return DistributedCache.getLocalCacheFiles((Configuration)this.conf);
    }

    public Path[] getFileClassPaths() {
        return DistributedCache.getFileClassPaths((Configuration)this.conf);
    }

    private static String[] toTimestampStrs(long[] timestamps) {
        if (timestamps == null) {
            return null;
        }
        String[] result = new String[timestamps.length];
        for (int i = 0; i < timestamps.length; ++i) {
            result[i] = Long.toString(timestamps[i]);
        }
        return result;
    }

    public String[] getArchiveTimestamps() {
        return JobContextImpl.toTimestampStrs(DistributedCache.getArchiveTimestamps((Configuration)this.conf));
    }

    public String[] getFileTimestamps() {
        return JobContextImpl.toTimestampStrs(DistributedCache.getFileTimestamps((Configuration)this.conf));
    }

    public int getMaxMapAttempts() {
        return this.conf.getMaxMapAttempts();
    }

    public int getMaxReduceAttempts() {
        return this.conf.getMaxReduceAttempts();
    }

    public boolean getProfileEnabled() {
        return this.conf.getProfileEnabled();
    }

    public String getProfileParams() {
        return this.conf.getProfileParams();
    }

    public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
        return this.conf.getProfileTaskRange(isMap);
    }

    public String getUser() {
        return this.conf.getUser();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public JobConf getJobConf() {
        return this.conf;
    }

    public Progressable getProgressible() {
        return this.progress;
    }
}

