/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MRInputAMSplitGenerator
extends InputInitializer {
    private boolean sendSerializedEvents;
    private static final Logger LOG = LoggerFactory.getLogger(MRInputAMSplitGenerator.class);

    public MRInputAMSplitGenerator(InputInitializerContext initializerContext) {
        super(initializerContext);
    }

    public List<Event> initialize() throws Exception {
        Stopwatch sw = new Stopwatch().start();
        MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto = MRInputHelpers.parseMRInputPayload(this.getContext().getInputUserPayload());
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Time to parse MRInput payload into prot: " + sw.elapsedMillis());
        }
        sw.reset().start();
        Configuration conf = TezUtils.createConfFromByteString((ByteString)userPayloadProto.getConfigurationBytes());
        this.sendSerializedEvents = conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Emitting serialized splits: " + this.sendSerializedEvents + " for input " + this.getContext().getInputName());
            LOG.debug("Time converting ByteString to configuration: " + sw.elapsedMillis());
        }
        sw.reset().start();
        int totalResource = this.getContext().getTotalAvailableResource().getMemory();
        int taskResource = this.getContext().getVertexTaskResource().getMemory();
        float waves = conf.getFloat("tez.grouping.split-waves", 1.7f);
        int numTasks = (int)((float)totalResource * waves / (float)taskResource);
        boolean groupSplits = userPayloadProto.getGroupingEnabled();
        LOG.info("Input " + this.getContext().getInputName() + " asking for " + numTasks + " tasks. Headroom: " + totalResource + " Task Resource: " + taskResource + " waves: " + waves + ", groupingEnabled: " + groupSplits);
        JobConf jobConf = new JobConf(conf);
        jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
        InputSplitInfoMem inputSplitInfo = null;
        inputSplitInfo = groupSplits ? MRInputHelpers.generateInputSplitsToMem((Configuration)jobConf, true, numTasks) : MRInputHelpers.generateInputSplitsToMem((Configuration)jobConf, false, 0);
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Time to create splits to mem: " + sw.elapsedMillis());
        }
        ArrayList events = Lists.newArrayListWithCapacity((int)(inputSplitInfo.getNumTasks() + 1));
        InputConfigureVertexTasksEvent configureVertexEvent = InputConfigureVertexTasksEvent.create((int)inputSplitInfo.getNumTasks(), (VertexLocationHint)VertexLocationHint.create(inputSplitInfo.getTaskLocationHints()), (InputSpecUpdate)InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate());
        events.add(configureVertexEvent);
        if (this.sendSerializedEvents) {
            MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
            int count = 0;
            for (MRRuntimeProtos.MRSplitProto mrSplit : splitsProto.getSplitsList()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)count++, (ByteBuffer)mrSplit.toByteString().asReadOnlyByteBuffer());
                events.add(diEvent);
            }
        } else {
            int count = 0;
            if (inputSplitInfo.holdsNewFormatSplits()) {
                for (InputSplit split : inputSplitInfo.getNewFormatSplits()) {
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                    events.add(diEvent);
                }
            } else {
                for (org.apache.hadoop.mapred.InputSplit split : inputSplitInfo.getOldFormatSplits()) {
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                    events.add(diEvent);
                }
            }
        }
        return events;
    }

    public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        throw new UnsupportedOperationException("Not expecting to handle any events");
    }
}

