/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.split;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.mapred.split.SplitSizeEstimator;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.hadoop.mapred.split.TezMapredSplitsGrouper;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.TezException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TezGroupedSplitsInputFormat<K, V>
implements InputFormat<K, V>,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(TezGroupedSplitsInputFormat.class);
    InputFormat<K, V> wrappedInputFormat;
    int desiredNumSplits = 0;
    Configuration conf;
    SplitSizeEstimator estimator;
    SplitLocationProvider locationProvider;

    public void setInputFormat(InputFormat<K, V> wrappedInputFormat) {
        this.wrappedInputFormat = wrappedInputFormat;
        if (LOG.isDebugEnabled()) {
            LOG.debug("wrappedInputFormat: " + wrappedInputFormat.getClass().getName());
        }
    }

    public void setSplitSizeEstimator(SplitSizeEstimator estimator) {
        Preconditions.checkArgument((estimator != null ? 1 : 0) != 0);
        this.estimator = estimator;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Split size estimator : " + estimator);
        }
    }

    public void setSplitLocationProvider(SplitLocationProvider locationProvider) {
        Preconditions.checkArgument((locationProvider != null ? 1 : 0) != 0);
        this.locationProvider = locationProvider;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Split size location provider: " + locationProvider);
        }
    }

    public void setDesiredNumberOfSplits(int num) {
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0);
        this.desiredNumSplits = num;
        if (LOG.isDebugEnabled()) {
            LOG.debug("desiredNumSplits: " + this.desiredNumSplits);
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        InputSplit[] originalSplits = this.wrappedInputFormat.getSplits(job, numSplits);
        TezMapredSplitsGrouper grouper = new TezMapredSplitsGrouper();
        String wrappedInputFormatName = this.wrappedInputFormat.getClass().getName();
        return grouper.getGroupedSplits(this.conf, originalSplits, this.desiredNumSplits, wrappedInputFormatName, this.estimator, this.locationProvider);
    }

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        TezGroupedSplit groupedSplit = (TezGroupedSplit)split;
        try {
            this.initInputFormatFromSplit(groupedSplit);
        }
        catch (TezException e) {
            throw new IOException(e);
        }
        return new TezGroupedSplitsRecordReader(groupedSplit, job, reporter);
    }

    void initInputFormatFromSplit(TezGroupedSplit split) throws TezException {
        if (this.wrappedInputFormat == null) {
            Class<?> clazz = TezGroupedSplitsInputFormat.getClassFromName(split.wrappedInputFormatName);
            try {
                this.wrappedInputFormat = (InputFormat)org.apache.hadoop.util.ReflectionUtils.newInstance(clazz, (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new TezException((Throwable)e);
            }
        }
    }

    static Class<?> getClassFromName(String name) throws TezException {
        return ReflectionUtils.getClazz((String)name);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public class TezGroupedSplitsRecordReader
    implements RecordReader<K, V> {
        TezGroupedSplit groupedSplit;
        JobConf job;
        Reporter reporter;
        int idx = 0;
        long progress;
        RecordReader<K, V> curReader;

        public TezGroupedSplitsRecordReader(TezGroupedSplit split, JobConf job, Reporter reporter) throws IOException {
            this.groupedSplit = split;
            this.job = job;
            this.reporter = reporter;
            this.initNextRecordReader();
        }

        public boolean next(K key, V value) throws IOException {
            while (this.curReader == null || !this.curReader.next(key, value)) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K createKey() {
            return this.curReader.createKey();
        }

        public V createValue() {
            return this.curReader.createValue();
        }

        public float getProgress() throws IOException {
            return Math.min(1.0f, (float)this.getPos() / (float)this.groupedSplit.getLength());
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        protected boolean initNextRecordReader() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.groupedSplit.wrappedSplits.get(this.idx - 1).getLength();
                }
            }
            if (this.idx == this.groupedSplit.wrappedSplits.size()) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Init record reader for index " + this.idx + " of " + this.groupedSplit.wrappedSplits.size());
            }
            try {
                this.curReader = TezGroupedSplitsInputFormat.this.wrappedInputFormat.getRecordReader(this.groupedSplit.wrappedSplits.get(this.idx), this.job, this.reporter);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.idx;
            return true;
        }

        public long getPos() throws IOException {
            long subprogress = 0L;
            if (null != this.curReader) {
                subprogress = this.curReader.getPos();
            }
            return this.progress + subprogress;
        }
    }
}

