/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.combine;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.mapreduce.task.ReduceContextImpl;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.hadoop.mapred.MRCounters;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.ValuesIterator;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;

@InterfaceAudience.Public
public class MRCombiner
implements Combiner {
    private static Log LOG = LogFactory.getLog(MRCombiner.class);
    private final Configuration conf;
    private final Class<?> keyClass;
    private final Class<?> valClass;
    private final RawComparator<?> comparator;
    private final boolean useNewApi;
    private final TezCounter combineInputKeyCounter;
    private final TezCounter combineInputValueCounter;
    private final MRTaskReporter reporter;
    private final TaskAttemptID mrTaskAttemptID;

    public MRCombiner(TaskContext taskContext) throws IOException {
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)taskContext.getUserPayload());
        assert (taskContext instanceof InputContext || taskContext instanceof OutputContext);
        if (taskContext instanceof OutputContext) {
            this.keyClass = ConfigUtils.getIntermediateOutputKeyClass((Configuration)this.conf);
            this.valClass = ConfigUtils.getIntermediateOutputValueClass((Configuration)this.conf);
            this.comparator = ConfigUtils.getIntermediateOutputKeyComparator((Configuration)this.conf);
            this.reporter = new MRTaskReporter((OutputContext)taskContext);
        } else {
            this.keyClass = ConfigUtils.getIntermediateInputKeyClass((Configuration)this.conf);
            this.valClass = ConfigUtils.getIntermediateInputValueClass((Configuration)this.conf);
            this.comparator = ConfigUtils.getIntermediateInputKeyComparator((Configuration)this.conf);
            this.reporter = new MRTaskReporter((InputContext)taskContext);
        }
        this.useNewApi = ConfigUtils.useNewApi((Configuration)this.conf);
        this.combineInputKeyCounter = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
        this.combineInputValueCounter = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS);
        boolean isMap = this.conf.getBoolean("tez.mapreduce.is_map_processor", false);
        this.mrTaskAttemptID = new TaskAttemptID(new TaskID(String.valueOf(taskContext.getApplicationId().getClusterTimestamp()), taskContext.getApplicationId().getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskContext.getTaskIndex()), taskContext.getTaskAttemptNumber());
        LOG.info((Object)("Using combineKeyClass: " + this.keyClass + ", combineValueClass: " + this.valClass + ", combineComparator: " + this.comparator + ", useNewApi: " + this.useNewApi));
    }

    public void combine(TezRawKeyValueIterator rawIter, IFile.Writer writer) throws InterruptedException, IOException {
        if (this.useNewApi) {
            this.runNewCombiner(rawIter, writer);
        } else {
            this.runOldCombiner(rawIter, writer);
        }
    }

    private void runOldCombiner(TezRawKeyValueIterator rawIter, final IFile.Writer writer) throws IOException {
        Class reducerClazz = this.conf.getClass("mapred.combiner.class", null, org.apache.hadoop.mapred.Reducer.class);
        org.apache.hadoop.mapred.Reducer combiner = (org.apache.hadoop.mapred.Reducer)ReflectionUtils.newInstance((Class)reducerClazz, (Configuration)this.conf);
        OutputCollector collector = new OutputCollector(){

            public void collect(Object key, Object value) throws IOException {
                writer.append(key, value);
            }
        };
        CombinerValuesIterator values = new CombinerValuesIterator(rawIter, this.keyClass, this.valClass, this.comparator);
        while (values.moveToNext()) {
            combiner.reduce(values.getKey(), values.getValues().iterator(), collector, (Reporter)this.reporter);
        }
    }

    private void runNewCombiner(TezRawKeyValueIterator rawIter, final IFile.Writer writer) throws InterruptedException, IOException {
        RecordWriter recordWriter = new RecordWriter(){

            public void write(Object key, Object value) throws IOException, InterruptedException {
                writer.append(key, value);
            }

            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            }
        };
        Class reducerClazz = this.conf.getClass("mapreduce.job.combine.class", null, Reducer.class);
        Reducer reducer = (Reducer)ReflectionUtils.newInstance((Class)reducerClazz, (Configuration)this.conf);
        Reducer.Context reducerContext = MRCombiner.createReduceContext(this.conf, this.mrTaskAttemptID, rawIter, (Counter)new MRCounters.MRCounter(this.combineInputKeyCounter), (Counter)new MRCounters.MRCounter(this.combineInputValueCounter), recordWriter, this.reporter, this.comparator, this.keyClass, this.valClass);
        reducer.run(reducerContext);
        recordWriter.close((TaskAttemptContext)reducerContext);
    }

    private static <KEYIN, VALUEIN, KEYOUT, VALUEOUT> Reducer.Context createReduceContext(Configuration conf, TaskAttemptID mrTaskAttemptID, final TezRawKeyValueIterator rawIter, Counter combineInputKeyCounter, Counter combineInputValueCounter, RecordWriter<KEYOUT, VALUEOUT> recordWriter, MRTaskReporter reporter, RawComparator<KEYIN> comparator, Class<KEYIN> keyClass, Class<VALUEIN> valClass) throws InterruptedException, IOException {
        RawKeyValueIterator r = new RawKeyValueIterator(){

            public boolean next() throws IOException {
                return rawIter.next();
            }

            public DataInputBuffer getValue() throws IOException {
                return rawIter.getValue();
            }

            public Progress getProgress() {
                return rawIter.getProgress();
            }

            public DataInputBuffer getKey() throws IOException {
                return rawIter.getKey();
            }

            public void close() throws IOException {
                rawIter.close();
            }
        };
        ReduceContextImpl rContext = new ReduceContextImpl(conf, mrTaskAttemptID, r, combineInputKeyCounter, combineInputValueCounter, recordWriter, null, (StatusReporter)reporter, comparator, keyClass, valClass);
        Reducer.Context reducerContext = new WrappedReducer().getReducerContext((ReduceContext)rContext);
        return reducerContext;
    }

    private final class CombinerValuesIterator<KEY, VALUE>
    extends ValuesIterator<KEY, VALUE> {
        public CombinerValuesIterator(TezRawKeyValueIterator rawIter, Class<KEY> keyClass, Class<VALUE> valClass, RawComparator<KEY> comparator) throws IOException {
            super(rawIter, comparator, keyClass, valClass, MRCombiner.this.conf, MRCombiner.this.combineInputKeyCounter, MRCombiner.this.combineInputValueCounter);
        }
    }
}

