/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezGroupedSplitsInputFormat<K, V>
extends InputFormat<K, V>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(TezGroupedSplitsInputFormat.class);
    InputFormat<K, V> wrappedInputFormat;
    int desiredNumSplits = 0;
    List<InputSplit> groupedSplits = null;
    Configuration conf;

    public void setInputFormat(InputFormat<K, V> wrappedInputFormat) {
        this.wrappedInputFormat = wrappedInputFormat;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wrappedInputFormat: " + wrappedInputFormat.getClass().getName()));
        }
    }

    public void setDesiredNumberOfSplits(int num) {
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0);
        this.desiredNumSplits = num;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("desiredNumSplits: " + this.desiredNumSplits));
        }
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        LOG.info((Object)"Grouping splits in Tez");
        int configNumSplits = this.conf.getInt("tez.am.grouping.split-count", 0);
        if (configNumSplits > 0) {
            this.desiredNumSplits = configNumSplits;
            LOG.info((Object)("Desired numSplits overridden by config to: " + this.desiredNumSplits));
        }
        List originalSplits = this.wrappedInputFormat.getSplits(context);
        if (configNumSplits <= 0 && originalSplits != null && originalSplits.size() != 0) {
            int newDesiredNumSplits;
            long minLengthPerGroup;
            long totalLength = 0L;
            for (InputSplit split : originalSplits) {
                totalLength += split.getLength();
            }
            int splitCount = this.desiredNumSplits > 0 ? this.desiredNumSplits : originalSplits.size();
            long lengthPerGroup = totalLength / (long)splitCount;
            long maxLengthPerGroup = this.conf.getLong("tez.am.grouping.max-size", TezConfiguration.TEZ_AM_GROUPING_SPLIT_MAX_SIZE_DEFAULT);
            if (maxLengthPerGroup < (minLengthPerGroup = this.conf.getLong("tez.am.grouping.min-size", TezConfiguration.TEZ_AM_GROUPING_SPLIT_MIN_SIZE_DEFAULT)) || minLengthPerGroup <= 0L) {
                throw new TezUncheckedException("Invalid max/min group lengths. Required min>0, max>=min.  max: " + maxLengthPerGroup + " min: " + minLengthPerGroup);
            }
            if (lengthPerGroup > maxLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / maxLengthPerGroup) + 1;
                LOG.info((Object)("Desired splits: " + this.desiredNumSplits + " too small. " + " Desired splitLength: " + lengthPerGroup + " Max splitLength: " + maxLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.size()));
                this.desiredNumSplits = newDesiredNumSplits;
            } else if (lengthPerGroup < minLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / minLengthPerGroup) + 1;
                LOG.info((Object)("Desired splits: " + this.desiredNumSplits + " too large. " + " Desired splitLength: " + lengthPerGroup + " Min splitLength: " + minLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.size()));
                this.desiredNumSplits = newDesiredNumSplits;
            }
        }
        String wrappedInputFormatName = this.wrappedInputFormat.getClass().getName();
        if (this.desiredNumSplits == 0 || originalSplits.size() == 0 || this.desiredNumSplits >= originalSplits.size()) {
            LOG.info((Object)("Using original number of splits: " + originalSplits.size() + " desired splits: " + this.desiredNumSplits));
            this.groupedSplits = new ArrayList<InputSplit>(originalSplits.size());
            for (InputSplit split : originalSplits) {
                TezGroupedSplit newSplit = new TezGroupedSplit(1, wrappedInputFormatName, split.getLocations());
                newSplit.addSplit(split);
                this.groupedSplits.add(newSplit);
            }
            return this.groupedSplits;
        }
        String emptyLocation = "EmptyLocation";
        String[] emptyLocations = new String[]{emptyLocation};
        this.groupedSplits = new ArrayList<InputSplit>(this.desiredNumSplits);
        long totalLength = 0L;
        HashMap<String, LocationHolder> distinctLocations = new HashMap<String, LocationHolder>();
        for (InputSplit split : originalSplits) {
            totalLength += split.getLength();
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                distinctLocations.put(location, null);
            }
        }
        long lengthPerGroup = totalLength / (long)this.desiredNumSplits;
        int numNodeLocations = distinctLocations.size();
        int numSplitsPerLocation = originalSplits.size() / numNodeLocations;
        int numSplitsInGroup = originalSplits.size() / this.desiredNumSplits;
        for (String location : distinctLocations.keySet()) {
            distinctLocations.put(location, new LocationHolder(numSplitsPerLocation));
        }
        for (InputSplit split : originalSplits) {
            SplitHolder splitHolder = new SplitHolder(split);
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                LocationHolder holder = (LocationHolder)distinctLocations.get(location);
                holder.splits.add(splitHolder);
            }
        }
        boolean groupByLength = this.conf.getBoolean("tez.am.grouping.by-length", true);
        boolean groupByCount = this.conf.getBoolean("tez.am.grouping.by-count", false);
        if (!groupByLength && !groupByCount) {
            throw new TezUncheckedException("None of the grouping parameters are true: tez.am.grouping.by-length, tez.am.grouping.by-count");
        }
        LOG.info((Object)("Desired numSplits: " + this.desiredNumSplits + " lengthPerGroup: " + lengthPerGroup + " numLocations: " + numNodeLocations + " numSplitsPerLocation: " + numSplitsPerLocation + " numSplitsInGroup: " + numSplitsInGroup + " totalLength: " + totalLength + " numOriginalSplits: " + originalSplits.size() + " . Grouping by length: " + groupByLength + " count: " + groupByCount));
        int splitsProcessed = 0;
        ArrayList<SplitHolder> group = new ArrayList<SplitHolder>(numSplitsInGroup);
        HashSet<String> groupLocationSet = new HashSet<String>(10);
        boolean allowSmallGroups = false;
        boolean doingRackLocal = false;
        int iterations = 0;
        while (splitsProcessed < originalSplits.size()) {
            ++iterations;
            int numFullGroupsCreated = 0;
            for (Map.Entry entry : distinctLocations.entrySet()) {
                group.clear();
                groupLocationSet.clear();
                String location = (String)entry.getKey();
                LocationHolder holder = (LocationHolder)entry.getValue();
                SplitHolder splitHolder = holder.getUnprocessedHeadSplit();
                if (splitHolder == null) continue;
                int oldHeadIndex = holder.headIndex;
                long groupLength = 0L;
                int groupNumSplits = 0;
                do {
                    group.add(splitHolder);
                    holder.incrementHeadIndex();
                } while ((splitHolder = holder.getUnprocessedHeadSplit()) != null && (!groupByLength || (groupLength += splitHolder.split.getLength()) + splitHolder.split.getLength() <= lengthPerGroup) && (!groupByCount || ++groupNumSplits + 1 <= numSplitsInGroup));
                if (!(!holder.isEmpty() || allowSmallGroups || groupByLength && groupLength >= lengthPerGroup / 2L || groupByCount && groupNumSplits >= numSplitsInGroup / 2)) {
                    holder.headIndex = oldHeadIndex;
                    continue;
                }
                ++numFullGroupsCreated;
                String[] groupLocation = new String[]{location};
                if (doingRackLocal) {
                    for (SplitHolder splitH : group) {
                        String[] locations = splitH.split.getLocations();
                        if (locations == null) continue;
                        for (String loc : locations) {
                            groupLocationSet.add(loc);
                        }
                    }
                    groupLocation = groupLocationSet.toArray(groupLocation);
                } else if (location == emptyLocation) {
                    groupLocation = null;
                }
                TezGroupedSplit groupedSplit = new TezGroupedSplit(group.size(), wrappedInputFormatName, groupLocation, doingRackLocal && location != emptyLocation ? location : null);
                for (SplitHolder groupedSplitHolder : group) {
                    groupedSplit.addSplit(groupedSplitHolder.split);
                    groupedSplitHolder.isProcessed = true;
                    ++splitsProcessed;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Grouped " + group.size() + " length: " + groupedSplit.getLength() + " split at: " + location));
                }
                this.groupedSplits.add(groupedSplit);
            }
            if (!doingRackLocal && numFullGroupsCreated < 1) {
                doingRackLocal = true;
                int numRemainingSplits = originalSplits.size() - splitsProcessed;
                HashSet<InputSplit> remainingSplits = new HashSet<InputSplit>(numRemainingSplits);
                for (Map.Entry entry : distinctLocations.entrySet()) {
                    LocationHolder locHolder = (LocationHolder)entry.getValue();
                    while (!locHolder.isEmpty()) {
                        SplitHolder splitHolder = locHolder.getUnprocessedHeadSplit();
                        if (splitHolder == null) continue;
                        remainingSplits.add(splitHolder.split);
                        locHolder.incrementHeadIndex();
                    }
                }
                if (remainingSplits.size() != numRemainingSplits) {
                    throw new TezUncheckedException("Expected: " + numRemainingSplits + " got: " + remainingSplits.size());
                }
                RackResolver.init((Configuration)this.conf);
                HashMap<String, String> locToRackMap = new HashMap<String, String>(distinctLocations.size());
                HashMap<String, LocationHolder> rackLocations = new HashMap<String, LocationHolder>();
                for (String location : distinctLocations.keySet()) {
                    String rack = emptyLocation;
                    if (location != emptyLocation) {
                        rack = RackResolver.resolve((String)location).getNetworkLocation();
                    }
                    locToRackMap.put(location, rack);
                    if (rackLocations.get(rack) != null) continue;
                    rackLocations.put(rack, new LocationHolder(numRemainingSplits));
                }
                HashSet rackSet = new HashSet(rackLocations.size());
                for (InputSplit split : remainingSplits) {
                    rackSet.clear();
                    SplitHolder splitHolder = new SplitHolder(split);
                    String[] locations = split.getLocations();
                    if (locations == null || locations.length == 0) {
                        locations = emptyLocations;
                    }
                    for (String location : locations) {
                        rackSet.add(locToRackMap.get(location));
                    }
                    for (String rack : rackSet) {
                        ((LocationHolder)rackLocations.get((Object)rack)).splits.add(splitHolder);
                    }
                }
                distinctLocations.clear();
                distinctLocations = rackLocations;
                float rackSplitReduction = this.conf.getFloat("tez.am.grouping.rack-split-reduction", 0.75f);
                if (rackSplitReduction > 0.0f) {
                    long newLengthPerGroup = (long)((float)lengthPerGroup * rackSplitReduction);
                    int newNumSplitsInGroup = (int)((float)numSplitsInGroup * rackSplitReduction);
                    if (newLengthPerGroup > 0L) {
                        lengthPerGroup = newLengthPerGroup;
                    }
                    if (newNumSplitsInGroup > 0) {
                        numSplitsInGroup = newNumSplitsInGroup;
                    }
                }
                LOG.info((Object)("Doing rack local after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + this.groupedSplits.size() + " lengthPerGroup: " + lengthPerGroup + " numSplitsInGroup: " + numSplitsInGroup));
                continue;
            }
            if (!allowSmallGroups && numFullGroupsCreated <= numNodeLocations / 10) {
                allowSmallGroups = true;
                LOG.info((Object)("Allowing small groups after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + this.groupedSplits.size()));
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + this.groupedSplits.size()));
        }
        LOG.info((Object)("Number of splits desired: " + this.desiredNumSplits + " created: " + this.groupedSplits.size() + " splitsProcessed: " + splitsProcessed));
        return this.groupedSplits;
    }

    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TezGroupedSplit groupedSplit = (TezGroupedSplit)split;
        this.initInputFormatFromSplit(groupedSplit);
        return new TezGroupedSplitsRecordReader(groupedSplit, context);
    }

    void initInputFormatFromSplit(TezGroupedSplit split) {
        if (this.wrappedInputFormat == null) {
            Class<?> clazz = TezGroupedSplitsInputFormat.getClassFromName(split.wrappedInputFormatName);
            try {
                this.wrappedInputFormat = (InputFormat)ReflectionUtils.newInstance(clazz, (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
    }

    static Class<?> getClassFromName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e1) {
            throw new TezUncheckedException((Throwable)e1);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TezGroupedSplitsRecordReader
    extends RecordReader<K, V> {
        TezGroupedSplit groupedSplit;
        TaskAttemptContext context;
        int idx = 0;
        long progress;
        RecordReader<K, V> curReader;

        public TezGroupedSplitsRecordReader(TezGroupedSplit split, TaskAttemptContext context) throws IOException {
            this.groupedSplit = split;
            this.context = context;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            if (this.groupedSplit != split) {
                throw new TezUncheckedException("Splits dont match");
            }
            if (this.context != context) {
                throw new TezUncheckedException("Contexts dont match");
            }
            this.initNextRecordReader();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            while (this.curReader == null || !this.curReader.nextKeyValue()) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.curReader.getCurrentKey();
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.curReader.getCurrentValue();
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        protected boolean initNextRecordReader() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    try {
                        this.progress += this.groupedSplit.wrappedSplits.get(this.idx - 1).getLength();
                    }
                    catch (InterruptedException e) {
                        throw new TezUncheckedException((Throwable)e);
                    }
                }
            }
            if (this.idx == this.groupedSplit.wrappedSplits.size()) {
                return false;
            }
            try {
                this.curReader = TezGroupedSplitsInputFormat.this.wrappedInputFormat.createRecordReader(this.groupedSplit.wrappedSplits.get(this.idx), this.context);
                this.curReader.initialize(this.groupedSplit.wrappedSplits.get(this.idx), this.context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.idx;
            return true;
        }

        public float getProgress() throws IOException, InterruptedException {
            long subprogress = 0L;
            if (null != this.curReader) {
                subprogress = (long)(this.curReader.getProgress() * (float)this.groupedSplit.wrappedSplits.get(this.idx - 1).getLength());
            }
            return Math.min(1.0f, (float)(this.progress + subprogress) / (float)this.groupedSplit.getLength());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LocationHolder {
        List<SplitHolder> splits;
        int headIndex = 0;

        LocationHolder(int capacity) {
            this.splits = new ArrayList<SplitHolder>(capacity);
        }

        boolean isEmpty() {
            return this.headIndex == this.splits.size();
        }

        SplitHolder getUnprocessedHeadSplit() {
            while (!this.isEmpty()) {
                SplitHolder holder = this.splits.get(this.headIndex);
                if (!holder.isProcessed) {
                    return holder;
                }
                this.incrementHeadIndex();
            }
            return null;
        }

        void incrementHeadIndex() {
            ++this.headIndex;
        }
    }

    class SplitHolder {
        InputSplit split;
        boolean isProcessed = false;

        SplitHolder(InputSplit split) {
            this.split = split;
        }
    }
}

