/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat;
import org.apache.tez.dag.api.TezUncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezGroupedSplit
extends InputSplit
implements Writable,
Configurable {
    List<InputSplit> wrappedSplits = null;
    String wrappedInputFormatName = null;
    String[] locations = null;
    String rack = null;
    long length = 0L;
    Configuration conf;

    public TezGroupedSplit() {
    }

    public TezGroupedSplit(int numSplits, String wrappedInputFormatName, String[] locations, String rack) {
        this.wrappedSplits = new ArrayList<InputSplit>(numSplits);
        this.wrappedInputFormatName = wrappedInputFormatName;
        this.locations = locations;
        this.rack = rack;
    }

    public TezGroupedSplit(int numSplits, String wrappedInputFormatName, String[] locations) {
        this(numSplits, wrappedInputFormatName, locations, null);
    }

    public void addSplit(InputSplit split) {
        this.wrappedSplits.add(split);
        try {
            this.length += split.getLength();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.wrappedSplits == null) {
            throw new TezUncheckedException("Wrapped splits cannot be empty");
        }
        Text.writeString((DataOutput)out, (String)this.wrappedInputFormatName);
        Text.writeString((DataOutput)out, (String)this.wrappedSplits.get(0).getClass().getName());
        out.writeInt(this.wrappedSplits.size());
        for (InputSplit split : this.wrappedSplits) {
            this.writeWrappedSplit(split, out);
        }
        out.writeLong(this.length);
        if (this.locations == null || this.locations.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.locations.length);
            for (String location : this.locations) {
                Text.writeString((DataOutput)out, (String)location);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.wrappedInputFormatName = Text.readString((DataInput)in);
        String inputSplitClassName = Text.readString((DataInput)in);
        Class<?> clazz = TezGroupedSplitsInputFormat.getClassFromName(inputSplitClassName);
        int numSplits = in.readInt();
        this.wrappedSplits = new ArrayList<InputSplit>(numSplits);
        for (int i = 0; i < numSplits; ++i) {
            this.addSplit(this.readWrappedSplit(in, clazz));
        }
        long recordedLength = in.readLong();
        if (recordedLength != this.length) {
            throw new TezUncheckedException("Expected length: " + recordedLength + " actual length: " + this.length);
        }
        int numLocs = in.readInt();
        if (numLocs > 0) {
            this.locations = new String[numLocs];
            for (int i = 0; i < numLocs; ++i) {
                this.locations[i] = Text.readString((DataInput)in);
            }
        }
    }

    void writeWrappedSplit(InputSplit split, DataOutput out) throws IOException {
        if (!(split instanceof Writable)) {
            throw new TezUncheckedException(split.getClass().getName() + " is not a Writable");
        }
        ((Writable)split).write(out);
    }

    InputSplit readWrappedSplit(DataInput in, Class<? extends InputSplit> clazz) {
        try {
            InputSplit split = clazz.newInstance();
            if (split instanceof Writable) {
                ((Writable)split).readFields(in);
                return split;
            }
            throw new TezUncheckedException(split.getClass().getName() + " is not a Writable");
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public long getLength() throws IOException, InterruptedException {
        return this.length;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return this.locations;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getRack() {
        return this.rack;
    }
}

