/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.processor;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.tez.common.TezUtils;
import org.apache.tez.mapreduce.examples.FilterLinesByWord;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.output.OnFileUnorderedKVOutput;

public class FilterByWordInputProcessor
implements LogicalIOProcessor {
    private static final Log LOG = LogFactory.getLog(FilterByWordInputProcessor.class);
    private String filterWord;

    public void initialize(TezProcessorContext processorContext) throws Exception {
        Configuration conf = TezUtils.createConfFromUserPayload((byte[])processorContext.getUserPayload());
        this.filterWord = conf.get("tez.runtime.examples.filterbyword.word");
        if (this.filterWord == null) {
            processorContext.fatalError(null, "No filter word specified");
        }
    }

    public void handleEvents(List<Event> processorEvents) {
        throw new UnsupportedOperationException("Not expecting any events to the broadcast processor");
    }

    public void close() throws Exception {
        LOG.info((Object)"Broadcast Processor closing. Nothing to do");
    }

    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        String fileName;
        if (inputs.size() != 1) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with a single input");
        }
        if (outputs.size() != 1) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with a single output");
        }
        for (LogicalInput input : inputs.values()) {
            input.start();
        }
        for (LogicalOutput output : outputs.values()) {
            output.start();
        }
        LogicalInput li = inputs.values().iterator().next();
        if (!(li instanceof MRInput)) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with MRInput");
        }
        LogicalOutput lo = outputs.values().iterator().next();
        if (!(lo instanceof OnFileUnorderedKVOutput)) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with OnFileUnorderedKVOutput");
        }
        MRInputLegacy mrInput = (MRInputLegacy)li;
        mrInput.init();
        OnFileUnorderedKVOutput kvOutput = (OnFileUnorderedKVOutput)lo;
        Configuration updatedConf = mrInput.getConfigUpdates();
        Text srcFile = new Text();
        srcFile.set("UNKNOWN_FILENAME_IN_PROCESSOR");
        if (updatedConf != null && (fileName = updatedConf.get("mapreduce.map.input.file")) != null) {
            LOG.info((Object)("Processing file: " + fileName));
            srcFile.set(fileName);
        }
        KeyValueReader kvReader = mrInput.getReader();
        KeyValueWriter kvWriter = kvOutput.getWriter();
        while (kvReader.next()) {
            Object key = kvReader.getCurrentKey();
            Object val = kvReader.getCurrentValue();
            Text valText = (Text)val;
            String readVal = valText.toString();
            if (!readVal.contains(this.filterWord)) continue;
            LongWritable lineNum = (LongWritable)key;
            FilterLinesByWord.TextLongPair outVal = new FilterLinesByWord.TextLongPair(srcFile, lineNum);
            kvWriter.write((Object)valText, (Object)outVal);
        }
    }
}

