/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples.terasort;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.mapreduce.examples.terasort.TeraInputFormat;
import org.apache.tez.mapreduce.examples.terasort.Unsigned16;

public class TeraChecksum
extends Configured
implements Tool {
    private static void usage() throws IOException {
        System.err.println("terasum <out-dir> <report-dir>");
    }

    public int run(String[] args) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf());
        if (args.length != 2) {
            TeraChecksum.usage();
            return 2;
        }
        TeraInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        job.setJobName("TeraSum");
        job.setJarByClass(TeraChecksum.class);
        job.setMapperClass(ChecksumMapper.class);
        job.setReducerClass(ChecksumReducer.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Unsigned16.class);
        job.setNumReduceTasks(1);
        job.setInputFormatClass(TeraInputFormat.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new TeraChecksum(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChecksumReducer
    extends Reducer<NullWritable, Unsigned16, NullWritable, Unsigned16> {
        ChecksumReducer() {
        }

        public void reduce(NullWritable key, Iterable<Unsigned16> values, Reducer.Context context) throws IOException, InterruptedException {
            Unsigned16 sum = new Unsigned16();
            for (Unsigned16 val : values) {
                sum.add(val);
            }
            context.write((Object)key, (Object)sum);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChecksumMapper
    extends Mapper<Text, Text, NullWritable, Unsigned16> {
        private Unsigned16 checksum = new Unsigned16();
        private Unsigned16 sum = new Unsigned16();
        private Checksum crc32 = new PureJavaCrc32();

        ChecksumMapper() {
        }

        public void map(Text key, Text value, Mapper.Context context) throws IOException {
            this.crc32.reset();
            this.crc32.update(key.getBytes(), 0, key.getLength());
            this.crc32.update(value.getBytes(), 0, value.getLength());
            this.checksum.set(this.crc32.getValue());
            this.sum.add(this.checksum);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)NullWritable.get(), (Object)this.sum);
        }
    }
}

