/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.DataMovementEvent;

@InterfaceAudience.Public
public final class CompositeRoutedDataMovementEvent
extends Event {
    private final int sourceIndex;
    private int targetIndex;
    private int count;
    private final ByteBuffer userPayload;
    private int version;

    @InterfaceAudience.Private
    public static CompositeRoutedDataMovementEvent create(int sourceIndex, int targetIndex, int count, int version, ByteBuffer userPayload) {
        return new CompositeRoutedDataMovementEvent(sourceIndex, targetIndex, count, version, userPayload);
    }

    @InterfaceAudience.Private
    CompositeRoutedDataMovementEvent(int sourceIndex, int targetIndex, int count, int version, ByteBuffer userPayload) {
        this.userPayload = userPayload;
        this.sourceIndex = sourceIndex;
        this.version = version;
        this.targetIndex = targetIndex;
        this.count = count;
    }

    public ByteBuffer getUserPayload() {
        return this.userPayload == null ? null : this.userPayload.asReadOnlyBuffer();
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    @InterfaceAudience.Private
    public void setTargetIndex(int targetIndex) {
        this.targetIndex = targetIndex;
    }

    public int getCount() {
        return this.count;
    }

    @InterfaceAudience.Private
    public void setCount(int count) {
        this.count = count;
    }

    public int getVersion() {
        return this.version;
    }

    @InterfaceAudience.Private
    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        return "CompositeRoutedDataMovementEvent [sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", count=" + this.count + ", version=" + this.version + "]";
    }

    @InterfaceAudience.Private
    public DataMovementEvent expand(int offset) {
        return DataMovementEvent.create(this.sourceIndex + offset, this.targetIndex + offset, this.version, this.userPayload);
    }
}

