/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;

@InterfaceAudience.Public
public class Vertex {
    private final String vertexName;
    private final ProcessorDescriptor processorDescriptor;
    private int parallelism;
    private VertexLocationHint locationHint;
    private Resource taskResource;
    private final Map<String, LocalResource> taskLocalResources = new HashMap<String, LocalResource>();
    private Map<String, String> taskEnvironment = new HashMap<String, String>();
    private final Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> additionalInputs = new HashMap<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>>();
    private final Map<String, RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>> additionalOutputs = new HashMap<String, RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>>();
    private VertexManagerPluginDescriptor vertexManagerPlugin;
    private final List<Vertex> inputVertices = new ArrayList<Vertex>();
    private final List<Vertex> outputVertices = new ArrayList<Vertex>();
    private final List<Edge> inputEdges = new ArrayList<Edge>();
    private final List<Edge> outputEdges = new ArrayList<Edge>();
    private final Map<String, VertexGroup.GroupInfo> groupInputs = Maps.newHashMap();
    private final List<DataSourceDescriptor> dataSources = Lists.newLinkedList();
    private final List<DataSinkDescriptor> dataSinks = Lists.newLinkedList();
    private String taskLaunchCmdOpts = "";

    @InterfaceAudience.Private
    Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        this(vertexName, processorDescriptor, parallelism, taskResource, false);
    }

    private Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism) {
        this(vertexName, processorDescriptor, parallelism, null, true);
    }

    private Vertex(String vertexName, ProcessorDescriptor processorDescriptor) {
        this(vertexName, processorDescriptor, -1);
    }

    private Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource, boolean allowIncomplete) {
        this.vertexName = vertexName;
        this.processorDescriptor = processorDescriptor;
        this.parallelism = parallelism;
        this.taskResource = taskResource;
        if (parallelism < -1) {
            throw new IllegalArgumentException("Parallelism should be -1 if determined by the AM, otherwise should be >= 0");
        }
        if (!allowIncomplete && taskResource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
    }

    public static Vertex create(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        return new Vertex(vertexName, processorDescriptor, parallelism, taskResource);
    }

    public static Vertex create(String vertexName, ProcessorDescriptor processorDescriptor) {
        return new Vertex(vertexName, processorDescriptor);
    }

    public static Vertex create(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism) {
        return new Vertex(vertexName, processorDescriptor, parallelism);
    }

    public String getName() {
        return this.vertexName;
    }

    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public Resource getTaskResource() {
        return this.taskResource;
    }

    public Vertex setLocationHint(VertexLocationHint locationHint) {
        List<TaskLocationHint> locations = locationHint.getTaskLocationHints();
        if (locations == null) {
            return this;
        }
        Preconditions.checkArgument((locations.size() == this.parallelism ? 1 : 0) != 0, (Object)"Locations array length must match the parallelism set for the vertex");
        this.locationHint = locationHint;
        return this;
    }

    VertexLocationHint getLocationHint() {
        return this.locationHint;
    }

    public Vertex addTaskLocalFiles(Map<String, LocalResource> localFiles) {
        if (localFiles != null) {
            TezCommonUtils.addAdditionalLocalResources(localFiles, this.taskLocalResources, "Vertex " + this.getName());
        }
        return this;
    }

    public Map<String, LocalResource> getTaskLocalFiles() {
        return this.taskLocalResources;
    }

    public Vertex setTaskEnvironment(Map<String, String> environment) {
        Preconditions.checkArgument((environment != null ? 1 : 0) != 0);
        this.taskEnvironment.putAll(environment);
        return this;
    }

    public Map<String, String> getTaskEnvironment() {
        return this.taskEnvironment;
    }

    public Vertex setTaskLaunchCmdOpts(String cmdOpts) {
        this.taskLaunchCmdOpts = cmdOpts;
        return this;
    }

    public Vertex addDataSource(String inputName, DataSourceDescriptor dataSourceDescriptor) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)inputName), (Object)("InputName should not be null, empty or white space only, inputName=" + inputName));
        Preconditions.checkArgument((!this.additionalInputs.containsKey(inputName) ? 1 : 0) != 0, (Object)("Duplicated input:" + inputName + ", vertexName=" + this.vertexName));
        this.additionalInputs.put(inputName, new RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>(inputName, dataSourceDescriptor.getInputDescriptor(), dataSourceDescriptor.getInputInitializerDescriptor()));
        this.dataSources.add(dataSourceDescriptor);
        return this;
    }

    public Vertex addDataSink(String outputName, DataSinkDescriptor dataSinkDescriptor) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)outputName), (Object)("OutputName should not be null, empty or white space only, outputName=" + outputName));
        Preconditions.checkArgument((!this.additionalOutputs.containsKey(outputName) ? 1 : 0) != 0, (Object)("Duplicated output:" + outputName + ", vertexName=" + this.vertexName));
        this.additionalOutputs.put(outputName, new RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>(outputName, dataSinkDescriptor.getOutputDescriptor(), dataSinkDescriptor.getOutputCommitterDescriptor()));
        this.dataSinks.add(dataSinkDescriptor);
        return this;
    }

    Vertex addAdditionalDataSink(RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> output) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)output.getName()), (Object)("OutputName should not be null, empty or white space only, outputName=" + output.getName()));
        Preconditions.checkArgument((!this.additionalOutputs.containsKey(output.getName()) ? 1 : 0) != 0, (Object)("Duplicated output:" + output.getName() + ", vertexName=" + this.vertexName));
        this.additionalOutputs.put(output.getName(), output);
        return this;
    }

    public Vertex setVertexManagerPlugin(VertexManagerPluginDescriptor vertexManagerPluginDescriptor) {
        this.vertexManagerPlugin = vertexManagerPluginDescriptor;
        return this;
    }

    public String getTaskLaunchCmdOpts() {
        return this.taskLaunchCmdOpts;
    }

    public String toString() {
        return "[" + this.vertexName + " : " + this.processorDescriptor.getClassName() + "]";
    }

    VertexManagerPluginDescriptor getVertexManagerPlugin() {
        return this.vertexManagerPlugin;
    }

    Map<String, VertexGroup.GroupInfo> getGroupInputs() {
        return this.groupInputs;
    }

    void addGroupInput(String groupName, VertexGroup.GroupInfo groupInputInfo) {
        if (this.groupInputs.put(groupName, groupInputInfo) != null) {
            throw new IllegalStateException("Vertex: " + this.getName() + " already has group input with name:" + groupName);
        }
    }

    void addInputVertex(Vertex inputVertex, Edge edge) {
        this.inputVertices.add(inputVertex);
        this.inputEdges.add(edge);
    }

    void addOutputVertex(Vertex outputVertex, Edge edge) {
        this.outputVertices.add(outputVertex);
        this.outputEdges.add(edge);
    }

    public List<Vertex> getInputVertices() {
        return Collections.unmodifiableList(this.inputVertices);
    }

    public List<Vertex> getOutputVertices() {
        return Collections.unmodifiableList(this.outputVertices);
    }

    void setTaskResource(Resource resource) {
        this.taskResource = resource;
    }

    @InterfaceAudience.Private
    public List<DataSourceDescriptor> getDataSources() {
        return this.dataSources;
    }

    @InterfaceAudience.Private
    public List<DataSinkDescriptor> getDataSinks() {
        return this.dataSinks;
    }

    List<Edge> getInputEdges() {
        return this.inputEdges;
    }

    List<Edge> getOutputEdges() {
        return this.outputEdges;
    }

    List<RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> getInputs() {
        return Lists.newArrayList(this.additionalInputs.values());
    }

    List<RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>> getOutputs() {
        return Lists.newArrayList(this.additionalOutputs.values());
    }
}

