/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.util.Iterator;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.DataMovementEvent;

public class CompositeDataMovementEvent
extends Event {
    protected final int sourceIndexStart;
    protected final int sourceIndexEnd;
    protected int version;
    protected final byte[] userPayload;

    public CompositeDataMovementEvent(int srcIndexStart, int srcIndexEnd, byte[] userPayload) {
        this.sourceIndexStart = srcIndexStart;
        this.sourceIndexEnd = srcIndexEnd;
        this.userPayload = userPayload;
    }

    public int getSourceIndexStart() {
        return this.sourceIndexStart;
    }

    public int getSourceIndexEnd() {
        return this.sourceIndexEnd;
    }

    public byte[] getUserPayload() {
        return this.userPayload;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public Iterable<DataMovementEvent> getEvents() {
        return new Iterable<DataMovementEvent>(){

            @Override
            public Iterator<DataMovementEvent> iterator() {
                return new Iterator<DataMovementEvent>(){
                    int currentPos;
                    {
                        this.currentPos = CompositeDataMovementEvent.this.sourceIndexStart;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentPos < CompositeDataMovementEvent.this.sourceIndexEnd;
                    }

                    @Override
                    public DataMovementEvent next() {
                        DataMovementEvent dmEvent = new DataMovementEvent(this.currentPos, CompositeDataMovementEvent.this.userPayload);
                        ++this.currentPos;
                        dmEvent.setVersion(CompositeDataMovementEvent.this.version);
                        return dmEvent;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported");
                    }
                };
            }
        };
    }
}

