/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.runtime.api.OutputCommitter;

public class VertexGroup {
    List<RootInputLeafOutput<OutputDescriptor>> outputs = Lists.newLinkedList();
    GroupInfo groupInfo;

    VertexGroup(String groupName, Vertex ... members) {
        if (members == null || members.length < 2) {
            throw new IllegalArgumentException("VertexGroup must have at least 2 members");
        }
        this.groupInfo = new GroupInfo(groupName, members);
    }

    public String getGroupName() {
        return this.groupInfo.groupName;
    }

    public VertexGroup addOutput(String outputName, OutputDescriptor outputDescriptor, Class<? extends OutputCommitter> outputCommitterClazz) {
        this.outputs.add(new RootInputLeafOutput<OutputDescriptor>(outputName, outputDescriptor, outputCommitterClazz));
        this.groupInfo.outputs.add(outputName);
        return this;
    }

    public String toString() {
        return "[ VertexGroup: " + this.groupInfo.getGroupName() + "]";
    }

    List<RootInputLeafOutput<OutputDescriptor>> getOutputs() {
        return this.outputs;
    }

    GroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    Set<Vertex> getMembers() {
        return this.groupInfo.members;
    }

    void addOutputVertex(Vertex outputVertex, GroupInputEdge edge) {
        this.groupInfo.edgeMergedInputs.put(outputVertex.getVertexName(), edge.getMergedInput());
    }

    static class GroupInfo {
        String groupName;
        Set<Vertex> members = new HashSet<Vertex>();
        Set<String> outputs = new HashSet<String>();
        Map<String, InputDescriptor> edgeMergedInputs = Maps.newHashMap();

        GroupInfo(String groupName, Vertex ... vertices) {
            this.groupName = groupName;
            this.members = Sets.newHashSetWithExpectedSize((int)vertices.length);
            for (Vertex v : vertices) {
                this.members.add(v);
            }
        }

        String getGroupName() {
            return this.groupName;
        }

        Set<Vertex> getMembers() {
            return this.members;
        }

        Set<String> getOutputs() {
            return this.outputs;
        }
    }
}

