/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;

public class DAG {
    final BidiMap<String, Vertex> vertices = new DualLinkedHashBidiMap();
    final Set<Edge> edges = Sets.newHashSet();
    final String name;
    final Collection<URI> urisForCredentials = new HashSet<URI>();
    Credentials credentials;
    Set<VertexGroup> vertexGroups = Sets.newHashSet();
    Set<GroupInputEdge> groupInputEdges = Sets.newHashSet();

    public DAG(String name) {
        this.name = name;
    }

    public synchronized DAG addVertex(Vertex vertex) {
        if (this.vertices.containsKey((Object)vertex.getVertexName())) {
            throw new IllegalStateException("Vertex " + vertex.getVertexName() + " already defined!");
        }
        this.vertices.put((Object)vertex.getVertexName(), (Object)vertex);
        return this;
    }

    public synchronized Vertex getVertex(String vertexName) {
        return (Vertex)this.vertices.get((Object)vertexName);
    }

    public synchronized DAG setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public synchronized VertexGroup createVertexGroup(String name, Vertex ... members) {
        VertexGroup uv = new VertexGroup(name, members);
        this.vertexGroups.add(uv);
        return uv;
    }

    @InterfaceAudience.Private
    public synchronized Credentials getCredentials() {
        return this.credentials;
    }

    public synchronized DAG addURIsForCredentials(Collection<URI> uris) {
        Preconditions.checkNotNull(uris, (Object)"URIs cannot be null");
        this.urisForCredentials.addAll(uris);
        return this;
    }

    @InterfaceAudience.Private
    public synchronized Collection<URI> getURIsForCredentials() {
        return Collections.unmodifiableCollection(this.urisForCredentials);
    }

    @InterfaceAudience.Private
    public synchronized Set<Vertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices.values());
    }

    public synchronized DAG addEdge(Edge edge) {
        if (!this.vertices.containsValue((Object)edge.getInputVertex())) {
            throw new IllegalArgumentException("Input vertex " + edge.getInputVertex() + " doesn't exist!");
        }
        if (!this.vertices.containsValue((Object)edge.getOutputVertex())) {
            throw new IllegalArgumentException("Output vertex " + edge.getOutputVertex() + " doesn't exist!");
        }
        if (this.edges.contains(edge)) {
            throw new IllegalArgumentException("Edge " + edge + " already defined!");
        }
        edge.getInputVertex().addOutputVertex(edge.getOutputVertex(), edge);
        edge.getOutputVertex().addInputVertex(edge.getInputVertex(), edge);
        this.edges.add(edge);
        return this;
    }

    public synchronized DAG addEdge(GroupInputEdge edge) {
        if (!this.vertexGroups.contains(edge.getInputVertexGroup())) {
            throw new IllegalArgumentException("Input vertex " + edge.getInputVertexGroup() + " doesn't exist!");
        }
        if (!this.vertices.containsValue((Object)edge.getOutputVertex())) {
            throw new IllegalArgumentException("Output vertex " + edge.getOutputVertex() + " doesn't exist!");
        }
        if (this.groupInputEdges.contains(edge)) {
            throw new IllegalArgumentException("Edge " + edge + " already defined!");
        }
        VertexGroup av = edge.getInputVertexGroup();
        av.addOutputVertex(edge.getOutputVertex(), edge);
        this.groupInputEdges.add(edge);
        return this;
    }

    public String getName() {
        return this.name;
    }

    private void processEdgesAndGroups() throws IllegalStateException {
        LinkedList newEdges = Lists.newLinkedList();
        for (GroupInputEdge groupInputEdge : this.groupInputEdges) {
            Vertex dstVertex = groupInputEdge.getOutputVertex();
            VertexGroup uv = groupInputEdge.getInputVertexGroup();
            for (Vertex member : uv.getMembers()) {
                newEdges.add(new Edge(member, dstVertex, groupInputEdge.getEdgeProperty()));
            }
            dstVertex.addGroupInput(uv.getGroupName(), uv.getGroupInfo());
        }
        for (Edge edge : newEdges) {
            this.addEdge(edge);
        }
        for (VertexGroup vertexGroup : this.vertexGroups) {
            for (RootInputLeafOutput<OutputDescriptor> output : vertexGroup.getOutputs()) {
                for (Vertex member : vertexGroup.getMembers()) {
                    member.addAdditionalOutput(output);
                }
            }
        }
    }

    public void verify() throws IllegalStateException {
        this.verify(true);
    }

    /*
     * WARNING - void declaration
     */
    public void verify(boolean restricted) throws IllegalStateException {
        Vertex vertex;
        if (this.vertices.isEmpty()) {
            throw new IllegalStateException("Invalid dag containing 0 vertices");
        }
        this.processEdgesAndGroups();
        HashMap<String, AnnotatedVertex> vertexMap = new HashMap<String, AnnotatedVertex>();
        HashMap<Vertex, HashSet<String>> inboundVertexMap = new HashMap<Vertex, HashSet<String>>();
        HashMap<Vertex, HashSet<String>> outboundVertexMap = new HashMap<Vertex, HashSet<String>>();
        for (Vertex v : this.vertices.values()) {
            if (vertexMap.containsKey(v.getVertexName())) {
                throw new IllegalStateException("DAG contains multiple vertices with name: " + v.getVertexName());
            }
            vertexMap.put(v.getVertexName(), new AnnotatedVertex(v));
        }
        HashMap<Vertex, List<Edge>> edgeMap = new HashMap<Vertex, List<Edge>>();
        for (Edge edge : this.edges) {
            void var10_25;
            Vertex inputVertex = edge.getInputVertex();
            Vertex vertex2 = edge.getOutputVertex();
            List list = (List)edgeMap.get(inputVertex);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                edgeMap.put(inputVertex, arrayList);
            }
            var10_25.add(edge);
            HashSet<String> inboundSet = (HashSet<String>)inboundVertexMap.get(vertex2);
            if (inboundSet == null) {
                inboundSet = new HashSet<String>();
                inboundVertexMap.put(vertex2, inboundSet);
            }
            inboundSet.add(inputVertex.getVertexName());
            HashSet<String> outboundSet = (HashSet<String>)outboundVertexMap.get(inputVertex);
            if (outboundSet == null) {
                outboundSet = new HashSet<String>();
                outboundVertexMap.put(inputVertex, outboundSet);
            }
            outboundSet.add(vertex2.getVertexName());
        }
        for (Vertex vertex3 : this.vertices.values()) {
            for (RootInputLeafOutput<InputDescriptor> rootInputLeafOutput : vertex3.getInputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getVertexName() + " contains an Input with the same name as vertex: " + rootInputLeafOutput.getName());
            }
            for (RootInputLeafOutput<TezEntityDescriptor> rootInputLeafOutput : vertex3.getOutputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getVertexName() + " contains an Output with the same name as vertex: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : inboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<InputDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getVertexName() + " contains an incoming vertex and Input with the same name: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : outboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<OutputDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getVertexName() + " contains an outgoing vertex and Output with the same name: " + rootInputLeafOutput.getName());
            }
        }
        this.detectCycles(edgeMap, vertexMap);
        if (restricted) {
            for (Edge edge : this.edges) {
                if (edge.getEdgeProperty().getDataSourceType() != EdgeProperty.DataSourceType.PERSISTED) {
                    throw new IllegalStateException("Unsupported source type on edge. " + edge);
                }
                if (edge.getEdgeProperty().getSchedulingType() == EdgeProperty.SchedulingType.SEQUENTIAL) continue;
                throw new IllegalStateException("Unsupported scheduling type on edge. " + edge);
            }
        }
    }

    private void detectCycles(Map<Vertex, List<Edge>> edgeMap, Map<String, AnnotatedVertex> vertexMap) throws IllegalStateException {
        Integer nextIndex = 0;
        Stack<AnnotatedVertex> stack = new Stack<AnnotatedVertex>();
        for (AnnotatedVertex av : vertexMap.values()) {
            if (av.index != -1) continue;
            assert (stack.empty());
            this.strongConnect(av, vertexMap, edgeMap, stack, nextIndex);
        }
    }

    private void strongConnect(AnnotatedVertex av, Map<String, AnnotatedVertex> vertexMap, Map<Vertex, List<Edge>> edgeMap, Stack<AnnotatedVertex> stack, Integer nextIndex) throws IllegalStateException {
        av.index = nextIndex;
        av.lowlink = nextIndex;
        Integer n = nextIndex;
        Integer n2 = nextIndex = Integer.valueOf(nextIndex + 1);
        stack.push(av);
        av.onstack = true;
        List<Edge> edges = edgeMap.get(av.v);
        if (edges != null) {
            for (Edge e : edgeMap.get(av.v)) {
                AnnotatedVertex outVertex = vertexMap.get(e.getOutputVertex().getVertexName());
                if (outVertex.index == -1) {
                    this.strongConnect(outVertex, vertexMap, edgeMap, stack, nextIndex);
                    av.lowlink = Math.min(av.lowlink, outVertex.lowlink);
                    continue;
                }
                if (!outVertex.onstack) continue;
                av.lowlink = Math.min(av.lowlink, outVertex.index);
            }
        }
        if (av.lowlink == av.index) {
            AnnotatedVertex pop = stack.pop();
            pop.onstack = false;
            if (pop != av) {
                StringBuilder message = new StringBuilder();
                message.append(av.v.getVertexName() + " <- ");
                while (pop != av) {
                    message.append(pop.v.getVertexName() + " <- ");
                    pop.onstack = false;
                    pop = stack.pop();
                }
                message.append(av.v.getVertexName());
                throw new IllegalStateException("DAG contains a cycle: " + message);
            }
        }
    }

    @InterfaceAudience.Private
    public DAGProtos.DAGPlan createDag(Configuration dagConf) {
        this.verify(true);
        DAGProtos.DAGPlan.Builder dagBuilder = DAGProtos.DAGPlan.newBuilder();
        dagBuilder.setName(this.name);
        if (!this.vertexGroups.isEmpty()) {
            for (VertexGroup av : this.vertexGroups) {
                VertexGroup.GroupInfo groupInfo = av.getGroupInfo();
                DAGProtos.PlanVertexGroupInfo.Builder groupBuilder = DAGProtos.PlanVertexGroupInfo.newBuilder();
                groupBuilder.setGroupName(groupInfo.getGroupName());
                for (Vertex vertex : groupInfo.getMembers()) {
                    groupBuilder.addGroupMembers(vertex.getVertexName());
                }
                groupBuilder.addAllOutputs(groupInfo.outputs);
                for (Map.Entry<String, InputDescriptor> entry : groupInfo.edgeMergedInputs.entrySet()) {
                    groupBuilder.addEdgeMergedInputs(DAGProtos.PlanGroupInputEdgeInfo.newBuilder().setDestVertexName(entry.getKey()).setMergedInput(DagTypeConverters.convertToDAGPlan(entry.getValue())));
                }
                dagBuilder.addVertexGroups(groupBuilder);
            }
        }
        for (Vertex vertex : this.vertices.values()) {
            DAGProtos.VertexPlan.Builder vertexBuilder = DAGProtos.VertexPlan.newBuilder();
            vertexBuilder.setName(vertex.getVertexName());
            vertexBuilder.setType(DAGProtos.PlanVertexType.NORMAL);
            vertexBuilder.setProcessorDescriptor(DagTypeConverters.convertToDAGPlan(vertex.getProcessorDescriptor()));
            if (vertex.getInputs().size() > 0) {
                for (RootInputLeafOutput<InputDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                    vertexBuilder.addInputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            if (vertex.getOutputs().size() > 0) {
                for (RootInputLeafOutput<TezEntityDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                    vertexBuilder.addOutputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            DAGProtos.PlanTaskConfiguration.Builder taskConfigBuilder = DAGProtos.PlanTaskConfiguration.newBuilder();
            Resource resource = vertex.getTaskResource();
            taskConfigBuilder.setNumTasks(vertex.getParallelism());
            taskConfigBuilder.setMemoryMb(resource.getMemory());
            taskConfigBuilder.setVirtualCores(resource.getVirtualCores());
            taskConfigBuilder.setJavaOpts(vertex.getJavaOpts());
            taskConfigBuilder.setTaskModule(vertex.getVertexName());
            DAGProtos.PlanLocalResource.Builder builder = DAGProtos.PlanLocalResource.newBuilder();
            builder.clear();
            for (Map.Entry<String, LocalResource> entry : vertex.getTaskLocalResources().entrySet()) {
                String key = entry.getKey();
                LocalResource lr = entry.getValue();
                builder.setName(key);
                builder.setUri(DagTypeConverters.convertToDAGPlan(lr.getResource()));
                builder.setSize(lr.getSize());
                builder.setTimeStamp(lr.getTimestamp());
                builder.setType(DagTypeConverters.convertToDAGPlan(lr.getType()));
                builder.setVisibility(DagTypeConverters.convertToDAGPlan(lr.getVisibility()));
                if (lr.getType() == LocalResourceType.PATTERN) {
                    if (lr.getPattern() == null || lr.getPattern().isEmpty()) {
                        throw new TezUncheckedException("LocalResource type set to pattern but pattern is null or empty");
                    }
                    builder.setPattern(lr.getPattern());
                }
                taskConfigBuilder.addLocalResource(builder);
            }
            for (String key : vertex.getTaskEnvironment().keySet()) {
                DAGProtos.PlanKeyValuePair.Builder envSettingBuilder = DAGProtos.PlanKeyValuePair.newBuilder();
                envSettingBuilder.setKey(key);
                envSettingBuilder.setValue(vertex.getTaskEnvironment().get(key));
                taskConfigBuilder.addEnvironmentSetting(envSettingBuilder);
            }
            if (vertex.getTaskLocationsHint() != null && vertex.getTaskLocationsHint().getTaskLocationHints() != null) {
                for (VertexLocationHint.TaskLocationHint hint : vertex.getTaskLocationsHint().getTaskLocationHints()) {
                    DAGProtos.PlanTaskLocationHint.Builder taskLocationHintBuilder = DAGProtos.PlanTaskLocationHint.newBuilder();
                    if (hint.getDataLocalHosts() != null) {
                        taskLocationHintBuilder.addAllHost(hint.getDataLocalHosts());
                    }
                    if (hint.getRacks() != null) {
                        taskLocationHintBuilder.addAllRack(hint.getRacks());
                    }
                    vertexBuilder.addTaskLocationHint(taskLocationHintBuilder);
                }
            }
            if (vertex.getVertexManagerPlugin() != null) {
                vertexBuilder.setVertexManagerPlugin(DagTypeConverters.convertToDAGPlan(vertex.getVertexManagerPlugin()));
            }
            for (String inEdgeId : vertex.getInputEdgeIds()) {
                vertexBuilder.addInEdgeId(inEdgeId);
            }
            for (String outEdgeId : vertex.getOutputEdgeIds()) {
                vertexBuilder.addOutEdgeId(outEdgeId);
            }
            vertexBuilder.setTaskConfig(taskConfigBuilder);
            dagBuilder.addVertex(vertexBuilder);
        }
        for (Edge edge : this.edges) {
            DAGProtos.EdgePlan.Builder edgeBuilder = DAGProtos.EdgePlan.newBuilder();
            edgeBuilder.setId(edge.getId());
            edgeBuilder.setInputVertexName(edge.getInputVertex().getVertexName());
            edgeBuilder.setOutputVertexName(edge.getOutputVertex().getVertexName());
            edgeBuilder.setDataMovementType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataMovementType()));
            edgeBuilder.setDataSourceType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataSourceType()));
            edgeBuilder.setSchedulingType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getSchedulingType()));
            edgeBuilder.setEdgeSource(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeSource()));
            edgeBuilder.setEdgeDestination(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeDestination()));
            if (edge.getEdgeProperty().getDataMovementType() == EdgeProperty.DataMovementType.CUSTOM && edge.getEdgeProperty().getEdgeManagerDescriptor() != null) {
                edgeBuilder.setEdgeManager(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeManagerDescriptor()));
            }
            dagBuilder.addEdge(edgeBuilder);
        }
        if (dagConf != null) {
            Iterator iter = dagConf.iterator();
            DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
                kvp.setKey((String)entry.getKey());
                kvp.setValue((String)entry.getValue());
                confProtoBuilder.addConfKeyValues(kvp);
            }
            dagBuilder.setDagKeyValues(confProtoBuilder);
        }
        if (this.credentials != null) {
            dagBuilder.setCredentialsBinary(DagTypeConverters.convertCredentialsToProto(this.credentials));
        }
        return dagBuilder.build();
    }

    private static class AnnotatedVertex {
        Vertex v;
        int index;
        int lowlink;
        boolean onstack;

        private AnnotatedVertex(Vertex v) {
            this.v = v;
            this.index = -1;
            this.lowlink = -1;
        }
    }
}

