/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.records.DAGProtos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexStatus {
    DAGProtos.VertexStatusProtoOrBuilder proxy = null;
    Progress progress = null;
    TezCounters vertexCounters = null;
    private AtomicBoolean countersInitialized = new AtomicBoolean(false);

    public VertexStatus(DAGProtos.VertexStatusProtoOrBuilder proxy) {
        this.proxy = proxy;
    }

    public State getState() {
        switch (this.proxy.getState()) {
            case VERTEX_INITED: {
                return State.INITED;
            }
            case VERTEX_RUNNING: {
                return State.RUNNING;
            }
            case VERTEX_SUCCEEDED: {
                return State.SUCCEEDED;
            }
            case VERTEX_FAILED: {
                return State.FAILED;
            }
            case VERTEX_KILLED: {
                return State.KILLED;
            }
            case VERTEX_ERROR: {
                return State.ERROR;
            }
            case VERTEX_TERMINATING: {
                return State.TERMINATING;
            }
        }
        throw new TezUncheckedException("Unsupported value for VertexStatus.State : " + (Object)((Object)this.proxy.getState()));
    }

    public List<String> getDiagnostics() {
        return this.proxy.getDiagnosticsList();
    }

    public Progress getProgress() {
        if (this.progress == null && this.proxy.hasProgress()) {
            this.progress = new Progress(this.proxy.getProgress());
        }
        return this.progress;
    }

    public TezCounters getVertexCounters() {
        if (this.countersInitialized.get()) {
            return this.vertexCounters;
        }
        if (this.proxy.hasVertexCounters()) {
            this.vertexCounters = DagTypeConverters.convertTezCountersFromProto(this.proxy.getVertexCounters());
        }
        this.countersInitialized.set(true);
        return this.vertexCounters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("status=" + (Object)((Object)this.getState()) + ", progress=" + this.getProgress() + ", counters=" + (this.vertexCounters == null ? "null" : this.vertexCounters.toString()));
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITED,
        RUNNING,
        SUCCEEDED,
        KILLED,
        FAILED,
        ERROR,
        TERMINATING;

    }
}

