/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.counters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.tez.common.counters.AbstractCounter;
import org.apache.tez.common.counters.TezCounter;

@InterfaceAudience.Private
public class GenericCounter
extends AbstractCounter {
    private String name;
    private String displayName;
    private long value = 0L;

    public GenericCounter() {
    }

    public GenericCounter(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public GenericCounter(String name, String displayName, long value) {
        this.name = name;
        this.displayName = displayName;
        this.value = value;
    }

    @Deprecated
    public synchronized void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public synchronized void readFields(DataInput in) throws IOException {
        this.name = Text.readString((DataInput)in);
        this.displayName = in.readBoolean() ? Text.readString((DataInput)in) : this.name;
        this.value = WritableUtils.readVLong((DataInput)in);
    }

    public synchronized void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.name);
        boolean distinctDisplayName = !this.name.equals(this.displayName);
        out.writeBoolean(distinctDisplayName);
        if (distinctDisplayName) {
            Text.writeString((DataOutput)out, (String)this.displayName);
        }
        WritableUtils.writeVLong((DataOutput)out, (long)this.value);
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getDisplayName() {
        return this.displayName;
    }

    public synchronized long getValue() {
        return this.value;
    }

    public synchronized void setValue(long value) {
        this.value = value;
    }

    public synchronized void increment(long incr) {
        this.value += incr;
    }

    public TezCounter getUnderlyingCounter() {
        return this;
    }
}

