/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TezCommonUtils {
    public static final FsPermission TEZ_AM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission TEZ_AM_FILE_PERMISSION = FsPermission.createImmutable((short)420);
    private static final Logger LOG = LoggerFactory.getLogger(TezClient.class);
    public static final String TEZ_SYSTEM_SUB_DIR = ".tez";
    private static final boolean NO_WRAP = true;

    public static Path getTezBaseStagingPath(Configuration conf) {
        Path baseStagingDir;
        String stagingDirStr = conf.get("tez.staging-dir", TezConfiguration.TEZ_AM_STAGING_DIR_DEFAULT);
        try {
            Path p = new Path(stagingDirStr);
            FileSystem fs = p.getFileSystem(conf);
            if (!fs.exists(p)) {
                TezCommonUtils.mkDirForAM(fs, p);
                LOG.info("Stage directory " + p + " doesn't exist and is created");
            }
            baseStagingDir = fs.resolvePath(p);
        }
        catch (IOException e) {
            throw new TezUncheckedException(e);
        }
        return baseStagingDir;
    }

    @InterfaceAudience.Private
    public static Path createTezSystemStagingPath(Configuration conf, String strAppId) {
        Path tezStagingDir;
        Path baseStagingPath = TezCommonUtils.getTezBaseStagingPath(conf);
        try {
            tezStagingDir = new Path(baseStagingPath, TEZ_SYSTEM_SUB_DIR);
            FileSystem fs = tezStagingDir.getFileSystem(conf);
            tezStagingDir = new Path(tezStagingDir, strAppId);
            if (!fs.exists(tezStagingDir)) {
                TezCommonUtils.mkDirForAM(fs, tezStagingDir);
                LOG.info("Tez system stage directory " + tezStagingDir + " doesn't exist and is created");
            }
        }
        catch (IOException e) {
            throw new TezUncheckedException(e);
        }
        return tezStagingDir;
    }

    @InterfaceAudience.Private
    public static Path getTezSystemStagingPath(Configuration conf, String strAppId) {
        Path baseStagingPath = TezCommonUtils.getTezBaseStagingPath(conf);
        Path tezStagingDir = new Path(baseStagingPath, TEZ_SYSTEM_SUB_DIR);
        tezStagingDir = new Path(tezStagingDir, strAppId);
        return tezStagingDir;
    }

    @InterfaceAudience.Private
    public static Path getTezConfStagingPath(Path tezSysStagingPath) {
        return new Path(tezSysStagingPath, "tez-conf.pb");
    }

    @InterfaceAudience.Private
    public static Path getTezAMJarStagingPath(Path tezSysStagingPath) {
        return new Path(tezSysStagingPath, "tez.session.local-resources.pb");
    }

    @InterfaceAudience.Private
    public static Path getTezBinPlanStagingPath(Path tezSysStagingPath) {
        return new Path(tezSysStagingPath, "tez-dag.pb");
    }

    @InterfaceAudience.Private
    public static Path getTezTextPlanStagingPath(Path tezSysStagingPath, String strAppId, String dagPBName) {
        String fileName = strAppId + "-" + dagPBName + "-" + "tez-dag.pb.txt";
        return new Path(tezSysStagingPath, fileName);
    }

    @InterfaceAudience.Private
    public static Path getRecoveryPath(Path tezSysStagingPath, Configuration conf) throws IOException {
        Path baseReecoveryPath = new Path(tezSysStagingPath, "recovery");
        FileSystem recoveryFS = baseReecoveryPath.getFileSystem(conf);
        return recoveryFS.makeQualified(baseReecoveryPath);
    }

    @InterfaceAudience.Private
    public static Path getAttemptRecoveryPath(Path recoveryPath, int attemptID) {
        return new Path(recoveryPath, Integer.toString(attemptID));
    }

    @InterfaceAudience.Private
    public static Path getDAGRecoveryPath(Path attemptRecoverPath, String dagID) {
        return new Path(attemptRecoverPath, dagID + ".recovery");
    }

    @InterfaceAudience.Private
    public static Path getSummaryRecoveryPath(Path attemptRecoverPath) {
        return new Path(attemptRecoverPath, "summary");
    }

    public static void mkDirForAM(FileSystem fs, Path dir) throws IOException {
        fs.mkdirs(dir, new FsPermission(TEZ_AM_DIR_PERMISSION));
    }

    public static FSDataOutputStream createFileForAM(FileSystem fs, Path filePath) throws IOException {
        return FileSystem.create((FileSystem)fs, (Path)filePath, (FsPermission)new FsPermission(TEZ_AM_FILE_PERMISSION));
    }

    public static void addAdditionalLocalResources(Map<String, LocalResource> additionalLrs, Map<String, LocalResource> originalLRs, String logContext) {
        if (additionalLrs != null && !additionalLrs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, LocalResource> lrEntry : additionalLrs.entrySet()) {
                LocalResource originalLr = originalLRs.get(lrEntry.getKey());
                if (originalLr != null) {
                    LocalResource additionalLr = lrEntry.getValue();
                    if (originalLr.getSize() != additionalLr.getSize()) {
                        throw new TezUncheckedException("Duplicate Resources found with different size for [" + logContext + "]: " + lrEntry.getKey() + " : [" + additionalLr.getResource() + "=" + additionalLr.getSize() + "],[" + originalLr.getResource() + "=" + originalLr.getSize());
                    }
                    if (originalLr.getResource().equals(additionalLr.getResource())) {
                        sb.append("[").append(lrEntry.getKey()).append(" : Duplicate]");
                    } else {
                        sb.append("[").append(lrEntry.getKey()).append(" : DuplicateDifferentPath]");
                    }
                }
                originalLRs.put(lrEntry.getKey(), lrEntry.getValue());
            }
            String logString = sb.toString();
            if (!logString.isEmpty()) {
                LOG.warn("Found Resources Duplication in " + logContext + " after including resources from " + "tez.lib.uris" + " and " + "tez.aux.uris" + ": " + logString);
            }
        }
    }

    @InterfaceAudience.Private
    public static Deflater newBestCompressionDeflater() {
        return new Deflater(9, true);
    }

    @InterfaceAudience.Private
    public static Deflater newBestSpeedDeflater() {
        return new Deflater(1, true);
    }

    @InterfaceAudience.Private
    public static Inflater newInflater() {
        return new Inflater(true);
    }

    @InterfaceAudience.Private
    public static ByteString compressByteArrayToByteString(byte[] inBytes) throws IOException {
        return TezCommonUtils.compressByteArrayToByteString(inBytes, TezCommonUtils.newBestCompressionDeflater());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static ByteString compressByteArrayToByteString(byte[] inBytes, Deflater deflater) throws IOException {
        deflater.reset();
        ByteString.Output os = ByteString.newOutput();
        try (DeflaterOutputStream compressOs = null;){
            ByteString byteString;
            compressOs = new DeflaterOutputStream((OutputStream)os, deflater);
            compressOs.write(inBytes);
            compressOs.finish();
            ByteString byteString2 = byteString = os.toByteString();
            return byteString2;
        }
    }

    @InterfaceAudience.Private
    public static byte[] decompressByteStringToByteArray(ByteString byteString) throws IOException {
        Inflater inflater = TezCommonUtils.newInflater();
        try {
            byte[] byArray = TezCommonUtils.decompressByteStringToByteArray(byteString, inflater);
            return byArray;
        }
        finally {
            inflater.end();
        }
    }

    @InterfaceAudience.Private
    public static byte[] decompressByteStringToByteArray(ByteString byteString, Inflater inflater) throws IOException {
        inflater.reset();
        try (InflaterInputStream inflaterInputStream = new InflaterInputStream(byteString.newInput(), inflater);){
            byte[] byArray = IOUtils.toByteArray((InputStream)inflaterInputStream);
            return byArray;
        }
    }

    public static String getCredentialsInfo(Credentials credentials, String identifier) {
        if (credentials == null) {
            return "Credentials: #" + identifier + "Tokens=null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Credentials: #" + identifier + "Tokens=").append(credentials.numberOfTokens());
        if (credentials.numberOfTokens() > 0) {
            sb.append(", Services=");
            sb.append(credentials.getAllTokens().stream().map(t -> String.format("%s(%s)", t.getService(), t.getKind())).collect(Collectors.joining(",")));
            sb.append(", TokenDetails=");
            sb.append(credentials.getAllTokens().stream().map(Token::toString).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }

    public static ByteBuffer convertJobTokenToBytes(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        jobToken.write((DataOutput)dob);
        ByteBuffer bb = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credentials parseCredentialsBytes(byte[] credentialsBytes) throws IOException {
        Credentials credentials = new Credentials();
        try (DataInputBuffer dib = new DataInputBuffer();){
            byte[] tokenBytes = credentialsBytes;
            dib.reset(tokenBytes, tokenBytes.length);
            credentials.readTokenStorageStream((DataInputStream)dib);
            Credentials credentials2 = credentials;
            return credentials2;
        }
    }

    public static void logCredentials(Logger log, Credentials credentials, String identifier) {
        if (log.isDebugEnabled()) {
            log.debug(TezCommonUtils.getCredentialsInfo(credentials, identifier));
        }
    }

    public static Collection<String> tokenizeString(String str, String delim) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null || str.isEmpty()) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || (str = str.trim()).isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return str.split("\\s*,\\s*");
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    public static String getSystemPropertiesToLog(Configuration conf) {
        List<String> keys = conf.getTrimmedStringCollection("tez.tez.jvm.system-properties-to-log");
        if (keys.isEmpty()) {
            keys = TezConfiguration.TEZ_JVM_SYSTEM_PROPERTIES_TO_LOG_DEFAULT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n/************************************************************\n");
        sb.append("[system properties]\n");
        for (String key : keys) {
            sb.append(key).append(": ").append(System.getProperty(key)).append('\n');
        }
        sb.append("************************************************************/");
        return sb.toString();
    }

    public static long getAMClientHeartBeatTimeoutMillis(Configuration conf) {
        int val = conf.getInt("tez.am.client.heartbeat.timeout.secs", -1);
        if (val < 0) {
            return -1L;
        }
        if (val > 0 && val < 10) {
            return 10000L;
        }
        return val * 1000;
    }

    public static long getAMClientHeartBeatPollIntervalMillis(Configuration conf, long heartbeatIntervalMillis, int buckets) {
        if (heartbeatIntervalMillis <= 0L) {
            return -1L;
        }
        int pollInterval = conf.getInt("tez.am.client.heartbeat.poll.interval.millis", -1);
        if (pollInterval > 0) {
            return Math.max(1000L, (long)pollInterval);
        }
        return Math.max(1000L, heartbeatIntervalMillis / (long)buckets);
    }

    public static long getDAGSessionTimeout(Configuration conf) {
        int timeoutSecs = conf.getInt("tez.session.am.dag.submit.timeout.secs", 300);
        if (timeoutSecs < 0) {
            return -1L;
        }
        if (timeoutSecs == 0) {
            timeoutSecs = 1;
        }
        return 1000L * (long)timeoutSecs;
    }
}

