/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.internal.webresources.AbstractMinimizer;
import org.apache.tapestry5.internal.webresources.CssCompressor;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.slf4j.Logger;

public class CSSMinimizer
extends AbstractMinimizer {
    public CSSMinimizer(Logger logger, OperationTracker tracker, AssetChecksumGenerator checksumGenerator) {
        super(logger, tracker, checksumGenerator, "text/css");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream doMinimize(StreamableResource resource) throws IOException {
        StringWriter writer = new StringWriter(1000);
        InputStreamReader reader = new InputStreamReader(resource.openStream());
        try {
            new CssCompressor(reader).compress(writer, -1);
            writer.flush();
            InputStream inputStream = IOUtils.toInputStream((CharSequence)writer.getBuffer());
            return inputStream;
        }
        finally {
            InternalUtils.close((Closeable)reader);
            InternalUtils.close((Closeable)writer);
        }
    }
}

