/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.text;

import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.util.text.ICharacterTranslator;
import org.apache.tapestry.util.text.ICharacterTranslatorSource;
import org.apache.tapestry.util.text.MarkupCharacterTranslator;

public class DefaultCharacterTranslatorSource
implements ICharacterTranslatorSource {
    private static final ICharacterTranslator DEFAULT_TRANSLATOR = new MarkupCharacterTranslator();
    private static final ICharacterTranslator UNICODE_TRANSLATOR = new MarkupCharacterTranslator(false);
    private static final Map _translators = new HashMap();

    public ICharacterTranslator getDefaultTranslator() {
        return DEFAULT_TRANSLATOR;
    }

    public ICharacterTranslator getTranslator(String encoding) {
        ICharacterTranslator translator = (ICharacterTranslator)_translators.get(encoding.toUpperCase());
        if (translator != null) {
            return translator;
        }
        return this.getDefaultTranslator();
    }

    static {
        _translators.put("UTF-8", UNICODE_TRANSLATOR);
        _translators.put("UTF-7", UNICODE_TRANSLATOR);
        _translators.put("UTF-16", UNICODE_TRANSLATOR);
        _translators.put("UTF-16BE", UNICODE_TRANSLATOR);
        _translators.put("UTF-16LE", UNICODE_TRANSLATOR);
    }
}

