/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.tapestry.Tapestry;

public class MultiKey
implements Externalizable {
    private static final long serialVersionUID = 4465448607415788806L;
    private static final int HASH_CODE_UNSET = -1;
    private transient int hashCode = -1;
    private Object[] _keys;

    public MultiKey() {
    }

    public MultiKey(Object[] keys, boolean makeCopy) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException(Tapestry.getMessage("MultiKey.null-keys"));
        }
        if (keys[0] == null) {
            throw new IllegalArgumentException(Tapestry.getMessage("MultiKey.first-element-may-not-be-null"));
        }
        if (makeCopy) {
            this._keys = new Object[keys.length];
            System.arraycopy(keys, 0, this._keys, 0, keys.length);
        } else {
            this._keys = keys;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this._keys == null) {
            throw new IllegalStateException(Tapestry.getMessage("MultiKey.no-keys"));
        }
        try {
            MultiKey otherMulti = (MultiKey)other;
            if (this._keys.length != otherMulti._keys.length) {
                return false;
            }
            for (int i = 0; i < this._keys.length; ++i) {
                if (this._keys[i] == otherMulti._keys[i]) continue;
                if (this._keys[i] == null || otherMulti._keys[i] == null) {
                    return false;
                }
                if (this._keys[i].equals(otherMulti._keys[i])) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this._keys[0].hashCode();
            for (int i = 1; i < this._keys.length; ++i) {
                if (this._keys[i] == null) continue;
                this.hashCode ^= this._keys[i].hashCode();
            }
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("MultiKey[");
        for (int i = 0; i < this._keys.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            if (this._keys[i] == null) {
                buffer.append("<null>");
                continue;
            }
            buffer.append(this._keys[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._keys.length);
        for (int i = 0; i < this._keys.length; ++i) {
            out.writeObject(this._keys[i]);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        this._keys = new Object[count];
        for (int i = 0; i < count; ++i) {
            this._keys[i] = in.readObject();
        }
    }
}

