/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.MessageFormatter;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.parse.OpenToken;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.services.impl.EngineServiceContribution;
import org.apache.tapestry.services.impl.InfrastructureContribution;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;

final class ImplMessages {
    private static final MessageFormatter _formatter = new MessageFormatter(ImplMessages.class);

    private ImplMessages() {
    }

    static String unknownRequest() {
        return _formatter.getMessage("unknown-request");
    }

    static String initializerContribution() {
        return _formatter.getMessage("initializer-contribution");
    }

    static String noApplicationSpecification(HttpServlet servlet) {
        return _formatter.format("no-application-specification", (Object)servlet.getServletName());
    }

    static String errorInstantiatingEngine(Class engineClass, Throwable cause) {
        return _formatter.format("error-instantiating-engine", (Object)engineClass.getName(), (Object)cause);
    }

    static String noTemplateForComponent(String componentId, Locale locale) {
        return _formatter.format("no-template-for-component", (Object)componentId, (Object)locale);
    }

    static String noTemplateForPage(String pageName, Locale locale) {
        return _formatter.format("no-template-for-page", (Object)pageName, (Object)locale);
    }

    static String unableToReadTemplate(Object template) {
        return _formatter.format("unable-to-read-template", template);
    }

    static String unableToParseTemplate(Resource resource) {
        return _formatter.format("unable-to-parse-template", (Object)resource);
    }

    static String unableToParseSpecification(Resource resource) {
        return _formatter.format("unable-to-parse-specification", (Object)resource);
    }

    static String unableToReadInfrastructureProperty(String propertyName, Infrastructure service, Throwable cause) {
        return _formatter.format("unable-to-read-infrastructure-property", (Object)propertyName, (Object)service, (Object)cause);
    }

    static String multipleComponentReferences(IComponent component, String id) {
        return _formatter.format("multiple-component-references", (Object)component.getExtendedId(), (Object)id);
    }

    static String dupeComponentId(String id, IContainedComponent containedComponent) {
        return _formatter.format("dupe-component-id", (Object)id, (Object)HiveMind.getLocationString((Object)containedComponent));
    }

    static String unbalancedCloseTags() {
        return _formatter.getMessage("unbalanced-close-tags");
    }

    static String templateBindingForInformalParameter(IComponent loadComponent, String parameterName, IComponent component) {
        return _formatter.format("template-binding-for-informal-parameter", (Object)loadComponent.getExtendedId(), (Object)parameterName, (Object)component.getExtendedId());
    }

    static String templateBindingForReservedParameter(IComponent loadComponent, String parameterName, IComponent component) {
        return _formatter.format("template-binding-for-reserved-parameter", (Object)loadComponent.getExtendedId(), (Object)parameterName, (Object)component.getExtendedId());
    }

    static String missingComponentSpec(IComponent component, Collection ids) {
        StringBuffer buffer = new StringBuffer();
        ArrayList idList = new ArrayList(ids);
        int count = idList.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(idList.get(i));
        }
        return _formatter.format("missing-component-spec", (Object)component.getExtendedId(), (Object)new Integer(count), (Object)buffer.toString());
    }

    static String bodylessComponent() {
        return _formatter.getMessage("bodyless-component");
    }

    static String dupeTemplateBinding(String name, IComponent component, IComponent loadComponent) {
        return _formatter.format("dupe-template-binding", (Object)name, (Object)component.getExtendedId(), (Object)loadComponent.getExtendedId());
    }

    static String unableToLoadProperties(URL url, Throwable cause) {
        return _formatter.format("unable-to-load-properties", (Object)url, (Object)cause);
    }

    static String noSuchService(String name) {
        return _formatter.format("no-such-service", (Object)name);
    }

    static String dupeService(String name, EngineServiceContribution existing) {
        return _formatter.format("dupe-service", (Object)name, (Object)HiveMind.getLocationString((Object)((Object)existing)));
    }

    static String unableToParseExpression(String expression, Throwable cause) {
        return _formatter.format("unable-to-parse-expression", (Object)expression, (Object)cause);
    }

    static String parsedExpression() {
        return _formatter.getMessage("parsed-expression");
    }

    static String unableToReadExpression(String expression, Object target, Throwable cause) {
        return _formatter.format("unable-to-read-expression", (Object)expression, target, (Object)cause);
    }

    static String unableToWriteExpression(String expression, Object target, Object value, Throwable cause) {
        return _formatter.format("unable-to-write-expression", new Object[]{expression, target, value, cause});
    }

    static String isConstantExpressionError(String expression, Exception ex) {
        return _formatter.format("is-constant-expression-error", (Object)expression, (Object)ex);
    }

    static String templateParameterName(String name) {
        return _formatter.format("template-parameter-name", (Object)name);
    }

    static String componentPropertySourceDescription(IComponentSpecification spec) {
        return _formatter.format("component-property-source-description", (Object)spec.getSpecificationLocation());
    }

    static String namespacePropertySourceDescription(INamespace namespace) {
        return _formatter.format("namespace-property-source-description", (Object)namespace.getExtendedId());
    }

    static String invalidEncoding(String encoding, Throwable cause) {
        return _formatter.format("invalid-encoding", (Object)encoding, (Object)cause);
    }

    static String errorResetting(Throwable cause) {
        return _formatter.format("error-resetting", (Object)cause);
    }

    static String engineServiceInnerProxyToString(String serviceName) {
        return _formatter.format("engine-service-inner-proxy-to-string", (Object)serviceName);
    }

    static String engineServiceOuterProxyToString(String serviceName) {
        return _formatter.format("engine-service-outer-proxy-to-string", (Object)serviceName);
    }

    static String serviceNameMismatch(IEngineService service, String expectedName, String actualName) {
        return _formatter.format("service-name-mismatch", (Object)service, (Object)expectedName, (Object)actualName);
    }

    static String infrastructureAlreadyInitialized(String newMode, String initializedMode) {
        return _formatter.format("infrastructure-already-initialized", (Object)newMode, (Object)initializedMode);
    }

    static String duplicateInfrastructureContribution(InfrastructureContribution conflict, Location existingLocation) {
        return _formatter.format("duplicate-infrastructure-contribution", (Object)conflict.getProperty(), (Object)conflict.getMode(), (Object)existingLocation);
    }

    static String infrastructureNotInitialized() {
        return _formatter.getMessage("infrastructure-not-initialized");
    }

    static String missingInfrastructureProperty(String propertyName) {
        return _formatter.format("missing-infrastructure-property", (Object)propertyName);
    }

    public static String usedTemplateParameterAlias(OpenToken token, String attributeName, String parameterName) {
        return _formatter.format("used-template-parameter-alias", new Object[]{HiveMind.getLocationString((Object)token), token.getType(), attributeName, parameterName});
    }

    static String engineClassNotFound(String engineClassName) {
        return _formatter.format("engine-class-not-found", (Object)engineClassName);
    }

    static String serviceNameIsNull() {
        return _formatter.getMessage("service-name-is-null");
    }
}

