/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.script;

import java.util.Map;
import org.apache.hivemind.Resource;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.script.ScriptSession;
import org.apache.tapestry.services.ExpressionEvaluator;

public class ScriptSessionImpl
implements ScriptSession {
    private IRequestCycle _cycle;
    private IScriptProcessor _processor;
    private Resource _scriptTemplateResource;
    private Map _symbols;
    private ExpressionEvaluator _evaluator;
    private ValueConverter _valueConverter;

    public ScriptSessionImpl(Resource scriptTemplateResource, IRequestCycle cycle, IScriptProcessor processor, ExpressionEvaluator evaluator, ValueConverter valueConverter, Map symbols) {
        this._scriptTemplateResource = scriptTemplateResource;
        this._cycle = cycle;
        this._processor = processor;
        this._symbols = symbols;
        this._evaluator = evaluator;
        this._valueConverter = valueConverter;
    }

    public Object evaluate(String expression) {
        return this._evaluator.read(this._symbols, expression);
    }

    public Object evaluate(String expression, Class desiredType) {
        Object raw = this.evaluate(expression);
        return this._valueConverter.coerceValue(raw, desiredType);
    }

    public Resource getScriptTemplateResource() {
        return this._scriptTemplateResource;
    }

    public Map getSymbols() {
        return this._symbols;
    }

    public IRequestCycle getRequestCycle() {
        return this._cycle;
    }

    public void addBodyScript(String script) {
        this.addBodyScript(null, script);
    }

    public void addBodyScript(IComponent target, String script) {
        this._processor.addBodyScript(target, script);
    }

    public void addExternalScript(Resource resource) {
        this.addExternalScript(null, resource);
    }

    public void addExternalScript(IComponent target, Resource resource) {
        this._processor.addExternalScript(target, resource);
    }

    public void addInitializationScript(String script) {
        this.addInitializationScript(null, script);
    }

    public void addInitializationScript(IComponent target, String script) {
        this._processor.addInitializationScript(target, script);
    }

    public String getUniqueString(String baseValue) {
        return this._processor.getUniqueString(baseValue);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ScriptSession[");
        buffer.append(this._scriptTemplateResource);
        buffer.append(']');
        return buffer.toString();
    }
}

