/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import org.apache.hivemind.util.Defense;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.record.PropertyChange;
import org.apache.tapestry.record.PropertyChangeImpl;
import org.apache.tapestry.record.WebSessionAttributeCallback;
import org.apache.tapestry.web.WebSession;

public final class RecordUtils {
    private RecordUtils() {
    }

    public static PropertyChange buildChange(String key, Object value) {
        String[] tokens = TapestryUtils.split(key);
        String idPath = tokens.length == 5 ? tokens[3] : null;
        String propertyName = tokens[tokens.length - 1];
        return new PropertyChangeImpl(idPath, propertyName, value);
    }

    public static void iterateOverMatchingAttributes(String strategyId, String applicationId, String pageName, WebSession session, WebSessionAttributeCallback callback) {
        Defense.notNull((Object)strategyId, (String)"strategyId");
        Defense.notNull((Object)applicationId, (String)"applicationId");
        Defense.notNull((Object)pageName, (String)"pageName");
        Defense.notNull((Object)session, (String)"session");
        String prefix = strategyId + "," + applicationId + "," + pageName + ",";
        for (String name : session.getAttributeNames()) {
            if (!name.startsWith(prefix)) continue;
            callback.handleAttribute(session, name);
        }
    }

    public static String buildChangeKey(String strategyId, String applicationId, String pageName, String idPath, String propertyName) {
        Defense.notNull((Object)strategyId, (String)"strategyId");
        Defense.notNull((Object)applicationId, (String)"applicationId");
        Defense.notNull((Object)pageName, (String)"pageName");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        StringBuffer buffer = new StringBuffer(strategyId);
        buffer.append(",");
        buffer.append(applicationId);
        buffer.append(",");
        buffer.append(pageName);
        if (idPath != null) {
            buffer.append(",");
            buffer.append(idPath);
        }
        buffer.append(",");
        buffer.append(propertyName);
        return buffer.toString();
    }
}

