/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.engine.ServiceEncoding;
import org.apache.tapestry.record.ClientPropertyPersistenceScope;
import org.apache.tapestry.record.PersistentPropertyData;
import org.apache.tapestry.record.PersistentPropertyDataEncoder;
import org.apache.tapestry.record.PropertyPersistenceStrategy;
import org.apache.tapestry.web.WebRequest;

public class ClientPropertyPersistenceStrategy
implements PropertyPersistenceStrategy {
    private final Map _data = new HashMap();
    private PersistentPropertyDataEncoder _encoder;
    private WebRequest _request;
    private ClientPropertyPersistenceScope _scope;

    public void initializeService() {
        List names = this._request.getParameterNames();
        for (String name : names) {
            if (!this._scope.isParameterForScope(name)) continue;
            String pageName = this._scope.extractPageName(name);
            String encoded = this._request.getParameterValue(name);
            PersistentPropertyData data = new PersistentPropertyData(this._encoder);
            data.storeEncoded(encoded);
            this._data.put(pageName, data);
        }
    }

    public void store(String pageName, String idPath, String propertyName, Object newValue) {
        PersistentPropertyData data = (PersistentPropertyData)this._data.get(pageName);
        if (data == null) {
            data = new PersistentPropertyData(this._encoder);
            this._data.put(pageName, data);
        }
        data.store(idPath, propertyName, newValue);
    }

    public Collection getStoredChanges(String pageName) {
        PersistentPropertyData data = (PersistentPropertyData)this._data.get(pageName);
        if (data == null) {
            return Collections.EMPTY_LIST;
        }
        return data.getPageChanges();
    }

    public void discardStoredChanges(String pageName) {
        this._data.remove(pageName);
    }

    public void addParametersForPersistentProperties(ServiceEncoding encoding, boolean post) {
        Defense.notNull((Object)encoding, (String)"encoding");
        for (Map.Entry e : this._data.entrySet()) {
            String pageName = (String)e.getKey();
            PersistentPropertyData data = (PersistentPropertyData)e.getValue();
            ClientPropertyPersistenceScope scope = this.getScope();
            if (!scope.shouldEncodeState(encoding, pageName, data)) continue;
            String parameterName = this._scope.constructParameterName(pageName);
            encoding.setParameterValue(parameterName, data.getEncoded());
        }
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public ClientPropertyPersistenceScope getScope() {
        return this._scope;
    }

    public void setScope(ClientPropertyPersistenceScope scope) {
        this._scope = scope;
    }

    public void setEncoder(PersistentPropertyDataEncoder encoder) {
        this._encoder = encoder;
    }
}

