/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.pageload;

import org.apache.hivemind.ClassResolver;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.resolver.PageSpecificationResolver;
import org.apache.tapestry.services.ObjectPool;
import org.apache.tapestry.util.MultiKey;

public class PageSource
implements IPageSource {
    private ClassResolver _classResolver;
    private PageSpecificationResolver _pageSpecificationResolver;
    private IPageLoader _loader;
    private ObjectPool _pool;

    public ClassResolver getClassResolver() {
        return this._classResolver;
    }

    protected MultiKey buildKey(IEngine engine, String pageName) {
        Object[] keys = new Object[]{pageName, engine.getLocale()};
        return new MultiKey(keys, false);
    }

    protected MultiKey buildKey(IPage page) {
        Object[] keys = new Object[]{page.getPageName(), page.getLocale()};
        return new MultiKey(keys, false);
    }

    public IPage getPage(IRequestCycle cycle, String pageName) {
        IEngine engine = cycle.getEngine();
        MultiKey key = this.buildKey(engine, pageName);
        IPage result = (IPage)this._pool.get(key);
        if (result == null) {
            this._pageSpecificationResolver.resolve(cycle, pageName);
            result = this._loader.loadPage(this._pageSpecificationResolver.getSimplePageName(), this._pageSpecificationResolver.getNamespace(), cycle, this._pageSpecificationResolver.getSpecification());
        } else {
            result.attach(engine, cycle);
        }
        return result;
    }

    public void releasePage(IPage page) {
        Tapestry.clearMethodInvocations();
        page.detach();
        Tapestry.checkMethodInvocation("AbstractPage.detach()", "detach()", page);
        this._pool.store(this.buildKey(page), page);
    }

    public void setPool(ObjectPool pool) {
        this._pool = pool;
    }

    public void setClassResolver(ClassResolver resolver) {
        this._classResolver = resolver;
    }

    public void setPageSpecificationResolver(PageSpecificationResolver resolver) {
        this._pageSpecificationResolver = resolver;
    }

    public void setLoader(IPageLoader loader) {
        this._loader = loader;
    }
}

