/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.markup;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.json.IJSONWriter;
import org.apache.tapestry.markup.AsciiMarkupFilter;
import org.apache.tapestry.markup.JSONWriterImpl;
import org.apache.tapestry.markup.MarkupFilter;
import org.apache.tapestry.markup.MarkupMessages;
import org.apache.tapestry.markup.MarkupWriterImpl;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.util.ContentType;

public class MarkupWriterSourceImpl
implements MarkupWriterSource {
    private Log _log;
    private MarkupFilter _defaultFilter = new AsciiMarkupFilter();
    private Map _contributions;

    public void setContributions(Map contributions) {
        this._contributions = contributions;
    }

    public IMarkupWriter newMarkupWriter(PrintWriter writer, ContentType contentType) {
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)contentType, (String)"contentType");
        MarkupFilter filter = this.findFilter(contentType);
        return new MarkupWriterImpl(contentType.toString(), writer, filter);
    }

    public IJSONWriter newJSONWriter(PrintWriter writer, ContentType contentType) {
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)contentType, (String)"contentType");
        return new JSONWriterImpl(writer);
    }

    private MarkupFilter findFilter(ContentType contentType) {
        String key = contentType.toString().toLowerCase();
        MarkupFilter result = (MarkupFilter)this._contributions.get(key);
        if (result == null) {
            result = (MarkupFilter)this._contributions.get(contentType.getMimeType());
        }
        if (result == null) {
            this._log.error((Object)MarkupMessages.noFilterMatch(contentType));
            result = this._defaultFilter;
        }
        return result;
    }

    public void setLog(Log log) {
        this._log = log;
    }
}

