/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.event.BrowserEvent;
import org.apache.tapestry.internal.event.EventBoundListener;

public class ComponentEventProperty {
    private Map _eventMap = new HashMap();
    private Map _formEventMap = new HashMap();
    private String _componentId;

    public ComponentEventProperty(String componentId) {
        this._componentId = componentId;
    }

    public void addListener(String[] events, String methodName, String formId, boolean validateForm, boolean async) {
        for (int i = 0; i < events.length; ++i) {
            if (formId != null && formId.length() > 0) {
                this.addFormEventListener(events[i], methodName, formId, validateForm, async);
                continue;
            }
            this.addEventListener(events[i], methodName);
        }
    }

    public void addFormEventListener(String event, String methodName, String formId, boolean validateForm, boolean async) {
        EventBoundListener listener = new EventBoundListener(methodName, formId, validateForm, this._componentId, async);
        List listeners = this.getFormEventListeners(event);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void addEventListener(String event, String methodName) {
        EventBoundListener listener = new EventBoundListener(methodName, this._componentId);
        List listeners = this.getEventListeners(event);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public String getComponentId() {
        return this._componentId;
    }

    public List getEventListeners(String event) {
        ArrayList listeners = (ArrayList)this._eventMap.get(event);
        if (listeners == null) {
            listeners = new ArrayList();
            this._eventMap.put(event, listeners);
        }
        return listeners;
    }

    public List getFormEventListeners(String event) {
        ArrayList listeners = (ArrayList)this._formEventMap.get(event);
        if (listeners == null) {
            listeners = new ArrayList();
            this._formEventMap.put(event, listeners);
        }
        return listeners;
    }

    public Set getEvents() {
        return this._eventMap.keySet();
    }

    public Set getFormEvents() {
        return this._formEventMap.keySet();
    }

    public List getFormEventListeners(String formId, BrowserEvent event, List append) {
        List ret = append == null ? new ArrayList() : append;
        List listeners = (List)this._formEventMap.get(event.getName());
        if (listeners == null) {
            return ret;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            EventBoundListener listener = (EventBoundListener)listeners.get(i);
            if (!listener.getFormId().equals(formId)) continue;
            ret.add(listener);
        }
        return ret;
    }
}

