/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.Date;
import java.util.Iterator;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.spec.IApplicationSpecification;

public abstract class Shell
extends AbstractComponent {
    private static final String GENERATOR_CONTENT = "Tapestry Application Framework, version " + Tapestry.VERSION;

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        long startTime = 0L;
        boolean rewinding = cycle.isRewinding();
        if (!rewinding) {
            IAsset stylesheet;
            startTime = System.currentTimeMillis();
            this.writeDocType(writer, cycle);
            IPage page = this.getPage();
            writer.comment("Application: " + this.getApplicationSpecification().getName());
            writer.comment("Page: " + page.getPageName());
            writer.comment("Generated: " + new Date());
            writer.begin("html");
            writer.println();
            writer.begin("head");
            writer.println();
            this.writeMetaTag(writer, "name", "generator", GENERATOR_CONTENT);
            if (this.isDisableCaching()) {
                this.writeMetaTag(writer, "http-equiv", "content", "no-cache");
            }
            if (this.getRenderContentType()) {
                this.writeMetaTag(writer, "http-equiv", "Content-Type", writer.getContentType());
            }
            if (this.getRenderBaseTag()) {
                this.getBaseTagWriter().render(writer, cycle);
            }
            writer.begin("title");
            writer.print(this.getTitle(), this.getRaw());
            writer.end();
            writer.println();
            IRender delegate = this.getDelegate();
            if (delegate != null) {
                delegate.render(writer, cycle);
            }
            IRender ajaxDelegate = this.getAjaxDelegate();
            if (this.isAjaxEnabled() && ajaxDelegate != null) {
                ajaxDelegate.render(writer, cycle);
            }
            if ((stylesheet = this.getStylesheet()) != null) {
                this.writeStylesheetLink(writer, cycle, stylesheet);
            }
            Iterator i = (Iterator)this.getValueConverter().coerceValue(this.getStylesheets(), Iterator.class);
            while (i.hasNext()) {
                stylesheet = (IAsset)i.next();
                this.writeStylesheetLink(writer, cycle, stylesheet);
            }
            this.writeRefresh(writer, cycle);
            writer.end();
        }
        this.renderBody(writer, cycle);
        if (!rewinding) {
            writer.end();
            writer.println();
            long endTime = System.currentTimeMillis();
            writer.comment("Render time: ~ " + (endTime - startTime) + " ms");
        }
    }

    private void writeDocType(IMarkupWriter writer, IRequestCycle cycle) {
        String doctype = this.getDoctype();
        if (HiveMind.isNonBlank((String)doctype)) {
            writer.printRaw("<!DOCTYPE " + doctype + ">");
            writer.println();
        }
    }

    private void writeStylesheetLink(IMarkupWriter writer, IRequestCycle cycle, IAsset stylesheet) {
        writer.beginEmpty("link");
        writer.attribute("rel", "stylesheet");
        writer.attribute("type", "text/css");
        writer.attribute("href", stylesheet.buildURL());
        writer.println();
    }

    private void writeRefresh(IMarkupWriter writer, IRequestCycle cycle) {
        int refresh = this.getRefresh();
        if (refresh <= 0) {
            return;
        }
        IEngineService pageService = this.getPageService();
        String pageName = this.getPage().getPageName();
        ILink link = pageService.getLink(false, pageName);
        StringBuffer buffer = new StringBuffer();
        buffer.append(refresh);
        buffer.append("; URL=");
        buffer.append(link.getAbsoluteURL());
        this.writeMetaTag(writer, "http-equiv", "Refresh", buffer.toString());
    }

    private void writeMetaTag(IMarkupWriter writer, String key, String value, String content) {
        writer.beginEmpty("meta");
        writer.attribute(key, value);
        writer.attribute("content", content);
        writer.println();
    }

    public abstract boolean isDisableCaching();

    public abstract boolean isAjaxEnabled();

    public abstract IRender getAjaxDelegate();

    public abstract IRender getDelegate();

    public abstract int getRefresh();

    public abstract IAsset getStylesheet();

    public abstract Object getStylesheets();

    public abstract String getTitle();

    public abstract String getDoctype();

    public abstract boolean getRenderContentType();

    public abstract ValueConverter getValueConverter();

    public abstract IEngineService getPageService();

    public abstract IApplicationSpecification getApplicationSpecification();

    public abstract IRender getBaseTagWriter();

    public abstract boolean getRenderBaseTag();

    public abstract boolean getRaw();
}

