/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.valid.ValidatorException;

public abstract class PropertySelection
extends AbstractFormComponent
implements ValidatableField {
    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.renderDelegatePrefix(writer, cycle);
        writer.begin("select");
        writer.attribute("name", this.getName());
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        if (this.getSubmitOnChange()) {
            writer.attribute("onchange", "javascript: this.form.events.submit();");
        }
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.getValidatableFieldSupport().renderContributions(this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.println();
        IPropertySelectionModel model = this.getModel();
        if (model == null) {
            throw Tapestry.createRequiredParameterException(this, "model");
        }
        int count = model.getOptionCount();
        boolean foundSelected = false;
        Object value = this.getValue();
        for (int i = 0; i < count; ++i) {
            Object option = model.getOption(i);
            writer.begin("option");
            writer.attribute("value", model.getValue(i));
            if (!foundSelected && this.isEqual(option, value)) {
                writer.attribute("selected", "selected");
                foundSelected = true;
            }
            writer.print(model.getLabel(i));
            writer.end();
            writer.println();
        }
        writer.end();
        this.renderDelegateSuffix(writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        Object object = this.getModel().translateValue(value);
        try {
            this.getValidatableFieldSupport().validate(this, writer, cycle, object);
            this.setValue(object);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    private boolean isEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public abstract IPropertySelectionModel getModel();

    public abstract boolean getSubmitOnChange();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired(this);
    }
}

