/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.Iterator;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.listener.ListenerInvoker;
import org.apache.tapestry.services.DataSqueezer;

public abstract class ListEdit
extends AbstractFormComponent {
    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.render(writer, cycle, this.getSource());
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String[] values = cycle.getParameters(this.getName());
        this.render(writer, cycle, (Iterator)this.getValueConverter().coerceValue(values, Iterator.class));
    }

    protected void render(IMarkupWriter writer, IRequestCycle cycle, Iterator i) {
        if (i == null) {
            return;
        }
        int index = 0;
        String element = this.getElement();
        boolean indexBound = this.isParameterBound("index");
        while (i.hasNext()) {
            Object value = null;
            if (indexBound) {
                this.setIndex(index++);
            }
            if (cycle.isRewinding()) {
                value = this.convertValue((String)i.next());
            } else {
                value = i.next();
                this.writeValue(this.getForm(), this.getName(), value);
            }
            this.setValue(value);
            this.getListenerInvoker().invokeListener(this.getListener(), this, cycle);
            if (element != null) {
                writer.begin(element);
                this.renderInformalParameters(writer, cycle);
            }
            this.renderBody(writer, cycle);
            if (element == null) continue;
            writer.end();
        }
    }

    private void writeValue(IForm form, String name, Object value) {
        String externalValue;
        try {
            externalValue = this.getDataSqueezer().squeeze(value);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ListEdit.unable-to-convert-value", value), (Object)this, null, (Throwable)ex);
        }
        form.addHiddenValue(name, externalValue);
    }

    private Object convertValue(String value) {
        try {
            return this.getDataSqueezer().unsqueeze(value);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ListEdit.unable-to-convert-string", value), (Object)this, null, (Throwable)ex);
        }
    }

    public abstract String getElement();

    public abstract IActionListener getListener();

    public boolean isDisabled() {
        return false;
    }

    public abstract Iterator getSource();

    public abstract void setValue(Object var1);

    public abstract void setIndex(int var1);

    public abstract DataSqueezer getDataSqueezer();

    public abstract ValueConverter getValueConverter();

    public abstract ListenerInvoker getListenerInvoker();

    protected boolean getCanTakeFocus() {
        return false;
    }

    public String getClientId() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }
}

