/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;

public abstract class AbstractFormComponent
extends AbstractComponent
implements IFormComponent {
    public abstract IForm getForm();

    public abstract void setForm(IForm var1);

    public abstract String getName();

    public abstract void setName(String var1);

    protected boolean getCanTakeFocus() {
        return !this.isDisabled();
    }

    public abstract String getIdParameter();

    public abstract void setClientId(String var1);

    protected void renderIdAttribute(IMarkupWriter writer, IRequestCycle cycle) {
        String rawId = this.getIdParameter();
        if (rawId == null) {
            return;
        }
        String id = cycle.getUniqueId(TapestryUtils.convertTapestryIdToNMToken(rawId));
        this.setClientId(id);
        writer.attribute("id", id);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = TapestryUtils.getForm(cycle, this);
        this.setForm(form);
        if (form.wasPrerendered(writer, this)) {
            return;
        }
        IValidationDelegate delegate = form.getDelegate();
        delegate.setFormComponent(this);
        this.setName(form);
        if (form.isRewinding()) {
            if (!this.isDisabled()) {
                this.rewindFormComponent(writer, cycle);
            }
            if (this.getRenderBodyOnRewind()) {
                this.renderBody(writer, cycle);
            }
        } else if (!cycle.isRewinding()) {
            if (!NullWriter.class.isInstance(writer)) {
                form.setFormFieldUpdating(true);
            }
            this.renderFormComponent(writer, cycle);
            if (this.getCanTakeFocus() && !this.isDisabled()) {
                delegate.registerForFocus(this, delegate.isInError() ? 3 : 1);
            }
        }
    }

    protected boolean getRenderBodyOnRewind() {
        return false;
    }

    protected void renderDelegatePrefix(IMarkupWriter writer, IRequestCycle cycle) {
        this.getForm().getDelegate().writePrefix(writer, cycle, this, null);
    }

    protected void renderDelegateAttributes(IMarkupWriter writer, IRequestCycle cycle) {
        this.getForm().getDelegate().writeAttributes(writer, cycle, this, null);
    }

    protected void renderDelegateSuffix(IMarkupWriter writer, IRequestCycle cycle) {
        this.getForm().getDelegate().writeSuffix(writer, cycle, this, null);
    }

    protected void setName(IForm form) {
        form.getElementId(this);
    }

    public boolean isRequired() {
        return false;
    }

    protected abstract void renderFormComponent(IMarkupWriter var1, IRequestCycle var2);

    protected abstract void rewindFormComponent(IMarkupWriter var1, IRequestCycle var2);
}

