/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IScript;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.enhance.DeferredScript;
import org.apache.tapestry.enhance.DeferredScriptImpl;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.spec.InjectSpecification;

public class InjectScriptWorker
implements InjectEnhancementWorker {
    private IScriptSource _source;

    public void performEnhancement(EnhancementOperation op, InjectSpecification spec) {
        String propertyName = spec.getProperty();
        String scriptName = spec.getObject();
        Location location = spec.getLocation();
        this.injectScript(op, propertyName, scriptName, location);
    }

    public void injectScript(EnhancementOperation op, String propertyName, String scriptName, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Defense.notNull((Object)scriptName, (String)"scriptName");
        Defense.notNull((Object)location, (String)"location");
        op.claimReadonlyProperty(propertyName);
        Class propertyType = EnhanceUtils.verifyPropertyType(op, propertyName, IScript.class);
        String methodName = op.getAccessorMethodName(propertyName);
        Resource resource = location.getResource().getRelativeResource(scriptName);
        DeferredScriptImpl script = new DeferredScriptImpl(resource, this._source, location);
        String fieldName = op.addInjectedField("_$script", DeferredScript.class, script);
        MethodSignature sig = new MethodSignature(propertyType, methodName, null, null);
        op.addMethod(1, sig, "return " + fieldName + ".getScript();", location);
    }

    public void setSource(IScriptSource source) {
        this._source = source;
    }
}

