/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.hivemind.Messages;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.services.ComponentMessagesSource;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectMessagesWorker
implements EnhancementWorker {
    final String _messagesProperty = "messages";
    final MethodSignature _methodSignature = new MethodSignature(Messages.class, "getMessages", null, null);
    private ErrorLog _errorLog;
    private ComponentMessagesSource _componentMessagesSource;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Location location = spec.getLocation();
        try {
            this.injectMessages(op, location);
        }
        catch (Exception ex) {
            this._errorLog.error(EnhanceMessages.errorAddingProperty("messages", op.getBaseClass(), ex), location, (Throwable)ex);
        }
    }

    public void injectMessages(EnhancementOperation op, Location location) {
        Defense.notNull((Object)op, (String)"op");
        op.claimReadonlyProperty("messages");
        String sourceField = op.addInjectedField("_$componentMessagesSource", ComponentMessagesSource.class, this._componentMessagesSource);
        op.addField("_$messages", Messages.class);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (_$messages == null)");
        builder.addln("  _$messages = {0}.getMessages(this);", (Object)sourceField);
        builder.addln("return _$messages;");
        builder.end();
        op.addMethod(1, this._methodSignature, builder.toString(), location);
    }

    public void setComponentMessagesSource(ComponentMessagesSource componentMessagesSource) {
        this._componentMessagesSource = componentMessagesSource;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

