/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.impl.ErrorLogImpl;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.engine.RequestCycleEnvironment;
import org.apache.tapestry.record.PageRecorderImpl;
import org.apache.tapestry.record.PropertyPersistenceStrategySource;
import org.apache.tapestry.services.AbsoluteURLBuilder;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.services.ResponseBuilder;
import org.apache.tapestry.util.IdAllocator;
import org.apache.tapestry.util.QueryParameterMap;

public class RequestCycle
implements IRequestCycle {
    private static final Log LOG = LogFactory.getLog(RequestCycle.class);
    protected ResponseBuilder _responseBuilder;
    private IPage _page;
    private IEngine _engine;
    private String _serviceName;
    private PropertyPersistenceStrategySource _strategySource;
    private IPageSource _pageSource;
    private Infrastructure _infrastructure;
    private QueryParameterMap _parameters;
    private AbsoluteURLBuilder _absoluteURLBuilder;
    private Map _loadedPages;
    private Map _pageRecorders;
    private boolean _rewinding = false;
    private Map _attributes = new HashMap();
    private int _targetActionId;
    private IComponent _targetComponent;
    private Object[] _listenerParameters;
    private ErrorLog _log;
    private IdAllocator _idAllocator = new IdAllocator();

    public RequestCycle(IEngine engine, QueryParameterMap parameters, String serviceName, RequestCycleEnvironment environment) {
        this._engine = engine;
        this._parameters = parameters;
        this._serviceName = serviceName;
        this._infrastructure = environment.getInfrastructure();
        this._pageSource = this._infrastructure.getPageSource();
        this._strategySource = environment.getStrategySource();
        this._absoluteURLBuilder = environment.getAbsoluteURLBuilder();
        this._log = new ErrorLogImpl(environment.getErrorHandler(), LOG);
    }

    public RequestCycle() {
    }

    public void cleanup() {
        if (this._loadedPages == null) {
            return;
        }
        for (IPage page : this._loadedPages.values()) {
            this._pageSource.releasePage(page);
        }
        this._loadedPages = null;
        this._pageRecorders = null;
    }

    public IEngineService getService() {
        return this._infrastructure.getServiceMap().getService(this._serviceName);
    }

    public String encodeURL(String URL2) {
        return this._infrastructure.getResponse().encodeURL(URL2);
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public IPage getPage() {
        return this._page;
    }

    public IPage getPage(String name) {
        Defense.notNull((Object)name, (String)"name");
        IPage result = null;
        if (this._loadedPages != null) {
            result = (IPage)this._loadedPages.get(name);
        }
        if (result == null) {
            result = this.loadPage(name);
            if (this._loadedPages == null) {
                this._loadedPages = new HashMap();
            }
            this._loadedPages.put(name, result);
        }
        return result;
    }

    private IPage loadPage(String name) {
        IPage result = this._pageSource.getPage(this, name);
        IPageRecorder recorder = this.getPageRecorder(name);
        recorder.rollback(result);
        result.setChangeObserver(recorder);
        return result;
    }

    protected IPageRecorder getPageRecorder(String name) {
        IPageRecorder result;
        if (this._pageRecorders == null) {
            this._pageRecorders = new HashMap();
        }
        if ((result = (IPageRecorder)this._pageRecorders.get(name)) == null) {
            result = new PageRecorderImpl(name, this._strategySource, this._log);
            this._pageRecorders.put(name, result);
        }
        return result;
    }

    public void setResponseBuilder(ResponseBuilder builder) {
        this._responseBuilder = builder;
    }

    public ResponseBuilder getResponseBuilder() {
        return this._responseBuilder;
    }

    public boolean isRewinding() {
        return this._rewinding;
    }

    public boolean isRewound(IComponent component) {
        if (!this._rewinding) {
            return false;
        }
        if (component == this._targetComponent) {
            return true;
        }
        throw new StaleLinkException(component, Integer.toHexString(this._targetActionId), this._targetComponent.getExtendedId());
    }

    public void removeAttribute(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing attribute " + name));
        }
        this._attributes.remove(name);
    }

    public void renderPage(ResponseBuilder builder) {
        this._rewinding = false;
        try {
            this._page.renderPage(builder, this);
        }
        catch (ApplicationRuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), (Object)this._page, null, ex);
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        this._attributes.clear();
        this._idAllocator.clear();
    }

    /*
     * Exception decompiling
     */
    public void rewindForm(IForm form) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setAttribute(String name, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set attribute " + name + " to " + value));
        }
        this._attributes.put(name, value);
    }

    public void commitPageChanges() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Committing page changes");
        }
        if (this._pageRecorders == null || this._pageRecorders.isEmpty()) {
            return;
        }
        for (IPageRecorder recorder : this._pageRecorders.values()) {
            recorder.commit();
        }
    }

    public void discardPage(String name) {
        this.forgetPage(name);
    }

    public Object[] getServiceParameters() {
        return this.getListenerParameters();
    }

    public void setServiceParameters(Object[] serviceParameters) {
        this.setListenerParameters(serviceParameters);
    }

    public Object[] getListenerParameters() {
        return this._listenerParameters;
    }

    public void setListenerParameters(Object[] parameters) {
        this._listenerParameters = parameters;
    }

    public void activate(String name) {
        IPage page = this.getPage(name);
        this.activate(page);
    }

    public void activate(IPage page) {
        Defense.notNull((Object)page, (String)"page");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activating page " + page));
        }
        Tapestry.clearMethodInvocations();
        page.validate(this);
        Tapestry.checkMethodInvocation("AbstractPage.validate()", "validate()", page);
        this._page = page;
    }

    public String getParameter(String name) {
        return this._parameters.getParameterValue(name);
    }

    public String[] getParameters(String name) {
        return this._parameters.getParameterValues(name);
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.append("rewinding", this._rewinding);
        b.append("serviceName", this._serviceName);
        b.append("serviceParameters", (Object)this._listenerParameters);
        if (this._loadedPages != null) {
            b.append("loadedPages", this._loadedPages.keySet());
        }
        b.append("attributes", (Object)this._attributes);
        b.append("targetActionId", this._targetActionId);
        b.append("targetComponent", (Object)this._targetComponent);
        return b.toString();
    }

    public String getAbsoluteURL(String partialURL) {
        String contextPath = this._infrastructure.getRequest().getContextPath();
        return this._absoluteURLBuilder.constructURL(contextPath + partialURL);
    }

    public void forgetPage(String pageName) {
        Defense.notNull((Object)pageName, (String)"pageName");
        this._strategySource.discardAllStoredChanged(pageName);
    }

    public Infrastructure getInfrastructure() {
        return this._infrastructure;
    }

    public String getUniqueId(String baseId) {
        return this._idAllocator.allocateId(baseId);
    }

    public void sendRedirect(String URL2) {
        throw new RedirectException(URL2);
    }
}

