/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.dojo.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IJSONRender;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.dojo.form.AbstractFormWidget;
import org.apache.tapestry.engine.DirectServiceParameter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.json.IJSONWriter;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.valid.ValidatorException;

public abstract class Autocompleter
extends AbstractFormWidget
implements ValidatableField,
IJSONRender,
IDirect {
    private static final String MODE_REMOTE = "remote";

    protected void renderFormWidget(IMarkupWriter writer, IRequestCycle cycle) {
        this.renderDelegatePrefix(writer, cycle);
        writer.begin("select");
        writer.attribute("name", this.getName());
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.getValidatableFieldSupport().renderContributions(this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.end();
        this.renderDelegateSuffix(writer, cycle);
        ILink link = this.getDirectService().getLink(true, new DirectServiceParameter(this));
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("id", this.getClientId());
        JSONObject json = new JSONObject();
        json.put("dataUrl", link.getURL() + "&filter=%{searchString}");
        json.put("mode", MODE_REMOTE);
        json.put("widgetId", this.getName());
        json.put("name", this.getName());
        IPropertySelectionModel model = this.getModel();
        if (model == null) {
            throw Tapestry.createRequiredParameterException(this, "model");
        }
        int count = model.getOptionCount();
        Object value = this.getValue();
        for (int i = 0; i < count; ++i) {
            Object option = model.getOption(i);
            if (!this.isEqual(option, value)) continue;
            json.put("value", model.getValue(i));
            json.put("label", model.getLabel(i));
            break;
        }
        parms.put("props", json.toString());
        parms.put("form", this.getForm().getName());
        PageRenderSupport prs = TapestryUtils.getPageRenderSupport(cycle, this);
        this.getScript().execute(cycle, prs, parms);
    }

    public void renderComponent(IJSONWriter writer, IRequestCycle cycle) {
        IPropertySelectionModel model = this.getModel();
        if (model == null) {
            throw Tapestry.createRequiredParameterException(this, "model");
        }
        int count = model.getOptionCount();
        for (int i = 0; i < count; ++i) {
            String value = model.getValue(i);
            String label = model.getLabel(i);
            if (this.getFilter() == null || this.getFilter().trim().length() <= 0) {
                writer.put(value, label);
                continue;
            }
            if (this.getFilter() == null || label.toLowerCase().indexOf(this.getFilter().toLowerCase()) <= -1) continue;
            writer.put(value, label);
        }
    }

    protected void rewindFormWidget(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        Object object = this.getModel().translateValue(value);
        try {
            this.getValidatableFieldSupport().validate(this, writer, cycle, object);
            this.setValue(object);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    private boolean isEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public boolean isStateful() {
        return true;
    }

    public void trigger(IRequestCycle cycle) {
        this.setFilter(cycle.getParameter("filter"));
    }

    public abstract IPropertySelectionModel getModel();

    public abstract boolean isFilterOnChange();

    public abstract boolean isAutocomplete();

    public abstract int getSearchDelay();

    public abstract int getFadeTime();

    public abstract int getMaxListLength();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void setFilter(String var1);

    public abstract String getFilter();

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public abstract IEngineService getDirectService();

    public abstract IScript getScript();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired(this);
    }

    public Collection getUpdateComponents() {
        ArrayList<String> comps = new ArrayList<String>();
        comps.add(this.getId());
        return comps;
    }

    public boolean isAsync() {
        return Boolean.TRUE;
    }

    public boolean isJson() {
        return Boolean.TRUE;
    }
}

