/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.callback;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.callback.CallbackMessages;
import org.apache.tapestry.callback.ICallback;

public class DirectCallback
implements ICallback {
    private static final long serialVersionUID = -8888847655917503471L;
    private String _pageName;
    private String _componentIdPath;
    private Object[] _parameters;

    public DirectCallback(IDirect component, Object[] parameters) {
        Defense.notNull((Object)component, (String)"component");
        this._pageName = component.getPage().getPageName();
        this._componentIdPath = component.getIdPath();
        this._parameters = parameters;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("DirectCallback[");
        buffer.append(this._pageName);
        buffer.append('/');
        buffer.append(this._componentIdPath);
        if (this._parameters != null) {
            for (int i = 0; i < this._parameters.length; ++i) {
                buffer.append(i == 0 ? " " : ", ");
                buffer.append(this._parameters[i]);
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void performCallback(IRequestCycle cycle) {
        IPage page = cycle.getPage(this._pageName);
        IComponent component = page.getNestedComponent(this._componentIdPath);
        IDirect direct = null;
        try {
            direct = (IDirect)component;
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(CallbackMessages.componentNotDirect(component), (Object)component, null, (Throwable)ex);
        }
        cycle.setListenerParameters(this._parameters);
        direct.trigger(cycle);
    }
}

