/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.util.IOUtils;
import org.apache.tapestry.asset.AssetMessages;
import org.apache.tapestry.asset.ResourceDigestSource;
import org.apache.tapestry.event.ReportStatusEvent;
import org.apache.tapestry.event.ReportStatusListener;
import org.apache.tapestry.event.ResetEventListener;

public class ResourceDigestSourceImpl
implements ResourceDigestSource,
ResetEventListener,
ReportStatusListener {
    private static final int BUFFER_SIZE = 5000;
    private String _serviceId;
    private ClassResolver _classResolver;
    private final Map _cache = new HashMap();

    public synchronized String getDigestForResource(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        String result = (String)this._cache.get(resourcePath);
        if (result == null) {
            result = this.computeMD5(resourcePath);
            this._cache.put(resourcePath, result);
        }
        return result;
    }

    public synchronized void resetEventDidOccur() {
        this._cache.clear();
    }

    public synchronized void reportStatus(ReportStatusEvent event) {
        event.title(this._serviceId);
        event.property("resource count", this._cache.size());
        for (Map.Entry entry : this._cache.entrySet()) {
            event.property(entry.getKey().toString(), entry.getValue());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeMD5(String resourcePath) {
        String string;
        URL url = this._classResolver.getResource(resourcePath);
        if (url == null) {
            throw new ApplicationRuntimeException(AssetMessages.noSuchResource(resourcePath));
        }
        BufferedInputStream stream = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            stream = new BufferedInputStream(url.openStream());
            this.digestStream(digest, stream);
            ((InputStream)stream).close();
            stream = null;
            byte[] bytes = digest.digest();
            char[] encoded = Hex.encodeHex((byte[])bytes);
            string = new String(encoded);
        }
        catch (IOException ex) {
            try {
                throw new ApplicationRuntimeException(AssetMessages.unableToReadResource(resourcePath, ex));
                catch (Exception ex2) {
                    throw new ApplicationRuntimeException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(stream);
                throw throwable;
            }
        }
        IOUtils.close((InputStream)stream);
        return string;
    }

    private void digestStream(MessageDigest digest, InputStream stream) throws IOException {
        byte[] buffer = new byte[5000];
        int length;
        while ((length = stream.read(buffer)) >= 0) {
            digest.update(buffer, 0, length);
        }
        return;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }
}

