/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Messages;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBeanProvider;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirectEvent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryMessages;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.bean.BeanProvider;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.event.BrowserEvent;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.listener.ListenerMap;
import org.apache.tapestry.services.ComponentRenderWorker;
import org.apache.tapestry.services.impl.ComponentEventInvoker;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;

public abstract class AbstractComponent
extends BaseLocatable
implements IDirectEvent {
    private static final int MAP_SIZE = 5;
    private static final int BODY_INIT_SIZE = 5;
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    protected String _clientId;
    private IPage _page;
    private IComponent _container;
    private String _id;
    private String _idPath;
    private Map _bindings;
    private Map _components;
    private INamespace _namespace;
    private int _bodyCount = 0;
    private IRender[] _body;
    private Map _assets;
    private ListenerMap _listeners;
    private IBeanProvider _beans;
    private boolean _rendering;
    private boolean _active;
    private IContainedComponent _containedComponent;

    public void addAsset(String name, IAsset asset) {
        Defense.notNull((Object)name, (String)"name");
        Defense.notNull((Object)asset, (String)"asset");
        this.checkActiveLock();
        if (this._assets == null) {
            this._assets = new HashMap(5);
        }
        this._assets.put(name, asset);
    }

    public void addComponent(IComponent component) {
        Defense.notNull((Object)component, (String)"component");
        this.checkActiveLock();
        if (this._components == null) {
            this._components = new HashMap(5);
        }
        this._components.put(component.getId(), component);
    }

    public void addBody(IRender element) {
        Defense.notNull((Object)element, (String)"element");
        if (this._body == null) {
            this._body = new IRender[5];
            this._body[0] = element;
            this._bodyCount = 1;
            return;
        }
        if (this._bodyCount == this._body.length) {
            IRender[] newWrapped = new IRender[this._body.length * 2];
            System.arraycopy(this._body, 0, newWrapped, 0, this._bodyCount);
            this._body = newWrapped;
        }
        this._body[this._bodyCount++] = element;
    }

    public void finishLoad(IRequestCycle cycle, IPageLoader loader, IComponentSpecification specification) {
        this.finishLoad();
    }

    protected void renderInformalParameters(IMarkupWriter writer, IRequestCycle cycle) {
        if (this._bindings == null) {
            return;
        }
        for (Map.Entry entry : this._bindings.entrySet()) {
            String attribute;
            IBinding binding;
            Object value;
            String name = (String)entry.getKey();
            if (this.isFormalParameter(name) || (value = (binding = (IBinding)entry.getValue()).getObject()) == null) continue;
            if (value instanceof IAsset) {
                IAsset asset = (IAsset)value;
                attribute = asset.buildURL();
            } else {
                attribute = value.toString();
            }
            writer.attribute(name, attribute);
        }
    }

    protected void renderIdAttribute(IMarkupWriter writer, IRequestCycle cycle) {
        String id;
        if (this._clientId == null) {
            id = this.getBoundId();
            if (id == null) {
                id = this.getId();
            }
            this._clientId = cycle.getUniqueId(TapestryUtils.convertTapestryIdToNMToken(id));
        }
        if ((id = this.getClientId()) != null) {
            writer.attribute("id", id);
        }
    }

    private boolean isFormalParameter(String name) {
        Defense.notNull((Object)name, (String)"name");
        return this.getSpecification().getParameter(name) != null;
    }

    public IBinding getBinding(String name) {
        Defense.notNull((Object)name, (String)"name");
        if (this._bindings == null) {
            return null;
        }
        return (IBinding)this._bindings.get(name);
    }

    public boolean isParameterBound(String parameterName) {
        Defense.notNull((Object)parameterName, (String)"parameterName");
        return this._bindings != null && this._bindings.containsKey(parameterName);
    }

    public IComponent getComponent(String id) {
        Defense.notNull((Object)id, (String)"id");
        IComponent result = null;
        if (this._components != null) {
            result = (IComponent)this._components.get(id);
        }
        if (result == null) {
            throw new ApplicationRuntimeException(Tapestry.format("no-such-component", this, id), (Object)this, null, null);
        }
        return result;
    }

    public IComponent getContainer() {
        return this._container;
    }

    public void setContainer(IComponent value) {
        this.checkActiveLock();
        if (this._container != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractComponent.attempt-to-change-container"));
        }
        this._container = value;
    }

    public String getExtendedId() {
        if (this._page == null) {
            return null;
        }
        return this._page.getPageName() + "/" + this.getIdPath();
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        if (this._id != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractComponent.attempt-to-change-component-id"));
        }
        this._id = value;
    }

    public String getIdPath() {
        if (this._container == null) {
            throw new NullPointerException(Tapestry.format("AbstractComponent.null-container", this));
        }
        String containerIdPath = this._container.getIdPath();
        this._idPath = containerIdPath == null ? this._id : containerIdPath + "." + this._id;
        return this._idPath;
    }

    public String getClientId() {
        if (this._clientId != null) {
            return this._clientId;
        }
        String boundId = this.getBoundId();
        if (boundId == null) {
            return this.getId();
        }
        return boundId;
    }

    String getBoundId() {
        if (this._bindings == null) {
            return null;
        }
        IBinding id = (IBinding)this._bindings.get("id");
        if (id == null) {
            return null;
        }
        return id.getObject().toString();
    }

    public IPage getPage() {
        return this._page;
    }

    public void setPage(IPage value) {
        if (this._page != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractComponent.attempt-to-change-page"));
        }
        this._page = value;
    }

    public void renderBody(IMarkupWriter writer, IRequestCycle cycle) {
        for (int i = 0; i < this._bodyCount; ++i) {
            cycle.getResponseBuilder().render(writer, this._body[i], cycle);
        }
    }

    public void setBinding(String name, IBinding binding) {
        Defense.notNull((Object)name, (String)"name");
        Defense.notNull((Object)binding, (String)"binding");
        if (this._bindings == null) {
            this._bindings = new HashMap(5);
        }
        this._bindings.put(name, binding);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('[');
        buffer.append(this.getExtendedId());
        buffer.append(']');
        return buffer.toString();
    }

    public Map getComponents() {
        if (this._components == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._components);
    }

    public Map getAssets() {
        if (this._assets == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._assets);
    }

    public IAsset getAsset(String name) {
        if (this._assets == null) {
            return null;
        }
        return (IAsset)this._assets.get(name);
    }

    public Collection getBindingNames() {
        if (this._container == null) {
            return null;
        }
        HashSet<Object> result = new HashSet<Object>();
        if (this._bindings != null) {
            result.addAll(this._bindings.keySet());
        }
        List names = this.getSpecification().getParameterNames();
        int count = names.size();
        for (int i = 0; i < count; ++i) {
            String name = (String)names.get(i);
            if (result.contains(name) || this.getBinding(name) == null) continue;
            result.add(name);
        }
        return result;
    }

    public Map getBindings() {
        if (this._bindings == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._bindings);
    }

    public ListenerMap getListeners() {
        if (this._listeners == null) {
            this._listeners = this.getPage().getEngine().getInfrastructure().getListenerMapSource().getListenerMapForObject(this);
        }
        return this._listeners;
    }

    public IBeanProvider getBeans() {
        if (this._beans == null) {
            this._beans = new BeanProvider(this);
        }
        return this._beans;
    }

    protected void finishLoad() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(IMarkupWriter writer, IRequestCycle cycle) {
        try {
            this._rendering = true;
            this.prepareForRender(cycle);
            this.renderComponent(writer, cycle);
            this.getRenderWorker().renderComponent(cycle, this);
        }
        finally {
            this._rendering = false;
            this.cleanupAfterRender(cycle);
            this._clientId = null;
        }
    }

    protected void prepareForRender(IRequestCycle cycle) {
    }

    protected abstract void renderComponent(IMarkupWriter var1, IRequestCycle var2);

    protected void cleanupAfterRender(IRequestCycle cycle) {
    }

    public INamespace getNamespace() {
        return this._namespace;
    }

    public void setNamespace(INamespace namespace) {
        this._namespace = namespace;
    }

    public IRender[] getBody() {
        return this._body;
    }

    public int getBodyCount() {
        return this._bodyCount;
    }

    public void pageEndRender(PageEvent event) {
    }

    public final boolean isRendering() {
        return this._rendering;
    }

    protected final boolean isInActiveState() {
        return this._active;
    }

    public final void enterActiveState() {
        this._active = true;
    }

    protected final void checkActiveLock() {
        if (this._active) {
            throw new UnsupportedOperationException(TapestryMessages.componentIsLocked(this));
        }
    }

    public Messages getMessages() {
        throw new IllegalStateException(TapestryMessages.providedByEnhancement("getMessages"));
    }

    public IComponentSpecification getSpecification() {
        throw new IllegalStateException(TapestryMessages.providedByEnhancement("getSpecification"));
    }

    public final IContainedComponent getContainedComponent() {
        return this._containedComponent;
    }

    public final void setContainedComponent(IContainedComponent containedComponent) {
        Defense.notNull((Object)containedComponent, (String)"containedComponent");
        if (this._containedComponent != null) {
            throw new ApplicationRuntimeException(TapestryMessages.attemptToChangeContainedComponent(this));
        }
        this._containedComponent = containedComponent;
    }

    public ComponentEventInvoker getEventInvoker() {
        throw new IllegalStateException(TapestryMessages.providedByEnhancement("getEventInvoker"));
    }

    public void triggerEvent(IRequestCycle cycle, BrowserEvent event) {
        this.getEventInvoker().invokeListeners(this, cycle, event);
    }

    public ComponentRenderWorker getRenderWorker() {
        throw new IllegalStateException(TapestryMessages.providedByEnhancement("getRenderWorker"));
    }

    public boolean isStateful() {
        return false;
    }
}

