// Copyright 2005 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry.services;

/**
 * Used to search for a class within a list of packages. Available as service tapestry.ClassFinder.
 * 
 * @author Howard Lewis Ship
 * @since 4.0
 */
public interface ClassFinder
{
    /**
     * Searches for a class within a list of packages, which always includes the default package.
     * 
     * @param packageList
     *            a comma seperated list of package names (i.e., "java.lang,java.util")
     * @param className
     *            the name of the class to search for. This may be just a class name, or even a
     *            partial class name (i.e., "impl.Foo").
     * @return the class, if found, or null if no class could be found in any of the packages
     */

    Class findClass(String packageList, String className);
}
