// Copyright Jun 25, 2006 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package org.apache.tapestry.json;


/**
 * Represents a JSON literal string, useful for scenerios where you
 * want to store a key/value pair but don't want the value to be quoted.
 * 
 * @author jkuhnert
 */
public class JSONLiteral
{
    private String _value;
    
    public JSONLiteral(String value)
    {
        _value = value;
    }
    
    public String toString()
    {
        return _value;
    }
}
