// Copyright 2004, 2005 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry.form;

/**
 * Used by a {@link PropertySelection} to provide labels for options.
 * <p>
 * The component requires three different representations of each option:
 * <ul>
 * <li>The option value, the server-side Java object that will eventually be assigned to a property
 * <li>The label, a string which is incorprated into the HTML to identify the option to the user
 * <li>The value, a client-side string which is used to represent the option as the value of the
 * &lt;option&gt; or &lt;input type=radio&gt; generated by the {@link PropertySelection}.
 * </ul>
 * <p>
 * The option is usually a string, a primitive value, or some kind of business object. The label is
 * often a property of the option object (for example, for a list of customers, it could be the
 * customer name).
 * <p>
 * It should be easy to convert between the value and the option. It may simply be an index into an
 * array. For business objects, it is often the primary key of the object, expressed as a String.
 * 
 * @author Howard Lewis Ship
 */

public interface IPropertySelectionModel
{
    /**
     * Returns the number of possible options.
     */

    int getOptionCount();

    /**
     * Returns one possible option that will be assigned to the server-side property.
     */

    Object getOption(int index);

    /**
     * Returns the label for an option. It is the responsibility of the adaptor to make this value
     * localized.
     */

    String getLabel(int index);

    /**
     * Returns a String used to represent the option in the HTML (as the value of an &lt;option&gt;
     * or &lt;input type=radio&gt;. This value is not visible to the user, and is often an index
     * into an array.
     */

    String getValue(int index);

    /**
     * Returns the option corresponding to a value. This is used when interpreting submitted form
     * parameters.
     */

    Object translateValue(String value);
}
