// Copyright 2004, 2005 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry.event;

import java.util.EventObject;

import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;

/**
 * Encapsulates information related to the page listener interfaces.
 * 
 * @author Howard Lewis Ship
 * @since 1.0.5
 */

public class PageEvent extends EventObject
{

    private static final long serialVersionUID = -6167989946862112436L;

    private transient IPage _page;
    private transient IRequestCycle _requestCycle;

    /**
     * Constructs a new instance of the event. The
     * {@link EventObject#getSource()} of the event will be the {@link IPage}.
     */

    public PageEvent(IPage page, IRequestCycle cycle)
    {
        super(page);

        this._page = page;
        this._requestCycle = cycle;
    }

    public IPage getPage()
    {
        return _page;
    }

    public IRequestCycle getRequestCycle()
    {
        return _requestCycle;
    }
}
