/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic.asm.optimizer;

import java.util.HashMap;
import org.apache.tapestry5.internal.plastic.asm.Handle;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.internal.plastic.asm.optimizer.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPool
extends HashMap<Constant, Constant> {
    private final Constant key1 = new Constant();
    private final Constant key2 = new Constant();
    private final Constant key3 = new Constant();
    private final Constant key4 = new Constant();
    private final Constant key5 = new Constant();

    public Constant newInteger(int value) {
        this.key1.set(value);
        Constant result = this.get(this.key1);
        if (result == null) {
            result = new Constant(this.key1);
            this.put(result);
        }
        return result;
    }

    public Constant newFloat(float value) {
        this.key1.set(value);
        Constant result = this.get(this.key1);
        if (result == null) {
            result = new Constant(this.key1);
            this.put(result);
        }
        return result;
    }

    public Constant newLong(long value) {
        this.key1.set(value);
        Constant result = this.get(this.key1);
        if (result == null) {
            result = new Constant(this.key1);
            this.put(result);
        }
        return result;
    }

    public Constant newDouble(double value) {
        this.key1.set(value);
        Constant result = this.get(this.key1);
        if (result == null) {
            result = new Constant(this.key1);
            this.put(result);
        }
        return result;
    }

    public Constant newUTF8(String value) {
        this.key1.set('s', value, null, null);
        Constant result = this.get(this.key1);
        if (result == null) {
            result = new Constant(this.key1);
            this.put(result);
        }
        return result;
    }

    private Constant newString(String value) {
        this.key2.set('S', value, null, null);
        Constant result = this.get(this.key2);
        if (result == null) {
            this.newUTF8(value);
            result = new Constant(this.key2);
            this.put(result);
        }
        return result;
    }

    public Constant newClass(String value) {
        this.key2.set('C', value, null, null);
        Constant result = this.get(this.key2);
        if (result == null) {
            this.newUTF8(value);
            result = new Constant(this.key2);
            this.put(result);
        }
        return result;
    }

    public Constant newMethodType(String methodDescriptor) {
        this.key2.set('t', methodDescriptor, null, null);
        Constant result = this.get(this.key2);
        if (result == null) {
            this.newUTF8(methodDescriptor);
            result = new Constant(this.key2);
            this.put(result);
        }
        return result;
    }

    public Constant newHandle(int tag, String owner, String name, String desc) {
        this.key4.set((char)(103 + tag), owner, name, desc);
        Constant result = this.get(this.key4);
        if (result == null) {
            if (tag <= 4) {
                this.newField(owner, name, desc);
            } else {
                this.newMethod(owner, name, desc, tag == 9);
            }
            result = new Constant(this.key4);
            this.put(result);
        }
        return result;
    }

    public Constant newConst(Object cst) {
        if (cst instanceof Integer) {
            int val = (Integer)cst;
            return this.newInteger(val);
        }
        if (cst instanceof Float) {
            float val = ((Float)cst).floatValue();
            return this.newFloat(val);
        }
        if (cst instanceof Long) {
            long val = (Long)cst;
            return this.newLong(val);
        }
        if (cst instanceof Double) {
            double val = (Double)cst;
            return this.newDouble(val);
        }
        if (cst instanceof String) {
            return this.newString((String)cst);
        }
        if (cst instanceof Type) {
            Type t = (Type)cst;
            int s = t.getSort();
            if (s == 10) {
                return this.newClass(t.getInternalName());
            }
            if (s == 11) {
                return this.newMethodType(t.getDescriptor());
            }
            return this.newClass(t.getDescriptor());
        }
        if (cst instanceof Handle) {
            Handle h = (Handle)cst;
            return this.newHandle(h.getTag(), h.getOwner(), h.getName(), h.getDesc());
        }
        throw new IllegalArgumentException("value " + cst);
    }

    public Constant newField(String owner, String name, String desc) {
        this.key3.set('G', owner, name, desc);
        Constant result = this.get(this.key3);
        if (result == null) {
            this.newClass(owner);
            this.newNameType(name, desc);
            result = new Constant(this.key3);
            this.put(result);
        }
        return result;
    }

    public Constant newMethod(String owner, String name, String desc, boolean itf) {
        this.key3.set(itf ? (char)'N' : 'M', owner, name, desc);
        Constant result = this.get(this.key3);
        if (result == null) {
            this.newClass(owner);
            this.newNameType(name, desc);
            result = new Constant(this.key3);
            this.put(result);
        }
        return result;
    }

    public Constant newInvokeDynamic(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.key5.set(name, desc, bsm, bsmArgs);
        Constant result = this.get(this.key5);
        if (result == null) {
            this.newNameType(name, desc);
            this.newHandle(bsm.getTag(), bsm.getOwner(), bsm.getName(), bsm.getDesc());
            for (int i = 0; i < bsmArgs.length; ++i) {
                this.newConst(bsmArgs[i]);
            }
            result = new Constant(this.key5);
            this.put(result);
        }
        return result;
    }

    public Constant newNameType(String name, String desc) {
        this.key2.set('T', name, desc, null);
        Constant result = this.get(this.key2);
        if (result == null) {
            this.newUTF8(name);
            this.newUTF8(desc);
            result = new Constant(this.key2);
            this.put(result);
        }
        return result;
    }

    private Constant get(Constant key) {
        return (Constant)this.get((Object)key);
    }

    private void put(Constant cst) {
        this.put(cst, cst);
    }
}

