/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.commons.internal.services;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.tapestry5.commons.AnnotationProvider;

public class AnnotationProviderChain
implements AnnotationProvider {
    private final AnnotationProvider[] providers;

    public AnnotationProviderChain(AnnotationProvider[] providers) {
        this.providers = providers;
    }

    public static AnnotationProvider create(List<AnnotationProvider> providers) {
        int size = providers.size();
        if (size == 1) {
            return providers.get(0);
        }
        return new AnnotationProviderChain(providers.toArray(new AnnotationProvider[providers.size()]));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (AnnotationProvider p : this.providers) {
            T result = p.getAnnotation(annotationClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

