/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap.mapping;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AbstractJDBCConf;
import org.apache.syncope.common.lib.AbstractLDAPConf;
import org.apereo.cas.configuration.model.support.ConnectionPoolingProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertySourceMapper {
    protected static final Logger LOG = LoggerFactory.getLogger(PropertySourceMapper.class);

    protected static Map<String, Object> prefix(String prefix, Map<String, Object> map) {
        return map.entrySet().stream().map(e -> Pair.of((Object)(prefix + (String)e.getKey()), e.getValue())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    protected void fill(AbstractLdapSearchProperties props, AbstractLDAPConf conf) {
        props.setLdapUrl(conf.getLdapUrl());
        props.setBaseDn(conf.getBaseDn());
        props.setSearchFilter(conf.getSearchFilter());
        props.setSubtreeSearch(conf.isSubtreeSearch());
        props.setPageSize(conf.getPageSize());
        props.setBindDn(conf.getBindDn());
        props.setBindCredential(conf.getBindCredential());
        props.setDisablePooling(conf.isDisablePooling());
        props.setMinPoolSize(conf.getMinPoolSize());
        props.setMaxPoolSize(conf.getMaxPoolSize());
        props.setPoolPassivator(AbstractLdapProperties.LdapConnectionPoolPassivator.valueOf((String)conf.getPoolPassivator().name()).name());
        props.setHostnameVerifier(AbstractLdapProperties.LdapHostnameVerifierOptions.valueOf((String)conf.getHostnameVerifier().name()));
        props.setTrustManager((String)Optional.ofNullable(conf.getTrustManager()).map(Enum::name).orElse(null));
        props.setValidateOnCheckout(conf.isValidateOnCheckout());
        props.setValidatePeriodically(conf.isValidatePeriodically());
        props.setValidateTimeout(conf.getValidateTimeout().toString());
        props.setValidatePeriod(conf.getValidatePeriod().toString());
        props.setFailFast(conf.isFailFast());
        props.setIdleTime(conf.getIdleTime().toString());
        props.setPrunePeriod(conf.getPrunePeriod().toString());
        props.setBlockWaitTime(conf.getBlockWaitTime().toString());
        props.setUseStartTls(conf.isUseStartTls());
        props.setConnectTimeout(conf.getConnectTimeout().toString());
        props.setResponseTimeout(conf.getResponseTimeout().toString());
        props.setAllowMultipleDns(conf.isAllowMultipleDns());
        props.setAllowMultipleEntries(conf.isAllowMultipleEntries());
        props.setFollowReferrals(conf.isFollowReferrals());
        props.setBinaryAttributes(conf.getBinaryAttributes());
    }

    protected void fill(AbstractJpaProperties props, AbstractJDBCConf conf) {
        props.setDialect(conf.getDialect());
        props.setDriverClass(conf.getDriverClass());
        props.setUrl(conf.getUrl());
        props.setUser(conf.getUser());
        props.setPassword(conf.getPassword());
        props.setDefaultCatalog(conf.getDefaultCatalog());
        props.setDefaultSchema(conf.getDefaultSchema());
        props.setHealthQuery(conf.getHealthQuery());
        props.setIdleTimeout(conf.getIdleTimeout().toString());
        props.setDataSourceName(conf.getDataSourceName());
        props.setLeakThreshold(conf.getPoolLeakThreshold().toString());
        ConnectionPoolingProperties connProps = new ConnectionPoolingProperties();
        connProps.setMinSize(conf.getMinPoolSize());
        connProps.setMaxSize(conf.getMaxPoolSize());
        connProps.setMaxWait(conf.getMaxPoolWait().toString());
        connProps.setSuspension(conf.isPoolSuspension());
        connProps.setTimeoutMillis(conf.getPoolTimeoutMillis());
        props.setPool(connProps);
    }
}

