/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.attr.AttrRepoConf;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.rest.api.service.AttrRepoService;
import org.apache.syncope.common.rest.api.service.AuthModuleService;
import org.apache.syncope.common.rest.api.service.wa.WAClientAppService;
import org.apache.syncope.common.rest.api.service.wa.WAConfigService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.bootstrap.mapping.AttrReleaseMapper;
import org.apache.syncope.wa.bootstrap.mapping.AttrRepoPropertySourceMapper;
import org.apache.syncope.wa.bootstrap.mapping.AuthModulePropertySourceMapper;
import org.apereo.cas.configuration.model.support.oidc.OidcDiscoveryProperties;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order
public class WAPropertySourceLocator
implements PropertySourceLocator {
    protected static final Logger LOG = LoggerFactory.getLogger(WAPropertySourceLocator.class);
    protected final WARestClient waRestClient;
    protected final AuthModulePropertySourceMapper authModulePropertySourceMapper;
    protected final AttrRepoPropertySourceMapper attrRepoPropertySourceMapper;
    protected final AttrReleaseMapper attrReleaseMapper;
    protected final CipherExecutor<String, String> configurationCipher;

    public WAPropertySourceLocator(WARestClient waRestClient, AuthModulePropertySourceMapper authModulePropertySourceMapper, AttrRepoPropertySourceMapper attrRepoPropertySourceMapper, AttrReleaseMapper attrReleaseMapper, CipherExecutor<String, String> configurationCipher) {
        this.waRestClient = waRestClient;
        this.authModulePropertySourceMapper = authModulePropertySourceMapper;
        this.attrRepoPropertySourceMapper = attrRepoPropertySourceMapper;
        this.attrReleaseMapper = attrReleaseMapper;
        this.configurationCipher = configurationCipher;
    }

    protected Map<String, Object> index(Map<String, Object> map, Map<String, Integer> prefixes) {
        String prefix;
        Map<String, Object> indexed = map;
        if (!map.isEmpty() && (prefix = map.keySet().iterator().next()).contains("[]")) {
            prefix = StringUtils.substringBefore((String)prefix, (String)"[]");
            Integer index = prefixes.getOrDefault(prefix, 0);
            indexed = map.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()).replace("[]", "[" + index + "]"), e.getValue())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            prefixes.put(prefix, index + 1);
        }
        return indexed;
    }

    public PropertySource<?> locate(Environment environment) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.warn("Application context is not ready to bootstrap WA configuration");
            return null;
        }
        LOG.info("Bootstrapping WA configuration");
        TreeMap<String, String> properties = new TreeMap<String, String>();
        HashMap prefixes = new HashMap();
        ((AuthModuleService)syncopeClient.getService(AuthModuleService.class)).list().forEach(authModuleTO -> {
            LOG.debug("Mapping auth module {} ", (Object)authModuleTO.getKey());
            Map map = authModuleTO.getConf().map(authModuleTO, (AuthModuleConf.Mapper)this.authModulePropertySourceMapper);
            properties.putAll(this.index(map, prefixes));
        });
        ((AttrRepoService)syncopeClient.getService(AttrRepoService.class)).list().forEach(attrRepoTO -> {
            LOG.debug("Mapping attr repo {} ", (Object)attrRepoTO.getKey());
            Map map = attrRepoTO.getConf().map(attrRepoTO, (AttrRepoConf.Mapper)this.attrRepoPropertySourceMapper);
            properties.putAll(this.index(map, prefixes));
        });
        Set customClaims = ((WAClientAppService)syncopeClient.getService(WAClientAppService.class)).list().stream().filter(app -> app.getClientAppTO() instanceof OIDCRPClientAppTO && app.getAttrReleasePolicy() != null).flatMap(app -> {
            RegisteredServiceAttributeReleasePolicy attributeReleasePolicy = this.attrReleaseMapper.build(app.getClientAppTO(), app.getAttrReleasePolicy());
            if (attributeReleasePolicy instanceof OidcCustomScopeAttributeReleasePolicy) {
                OidcCustomScopeAttributeReleasePolicy custom = (OidcCustomScopeAttributeReleasePolicy)attributeReleasePolicy;
                return custom.getAllowedAttributes().stream();
            }
            if (attributeReleasePolicy instanceof ChainingAttributeReleasePolicy) {
                ChainingAttributeReleasePolicy chain = (ChainingAttributeReleasePolicy)attributeReleasePolicy;
                return chain.getPolicies().stream().filter(OidcCustomScopeAttributeReleasePolicy.class::isInstance).map(OidcCustomScopeAttributeReleasePolicy.class::cast).flatMap(p -> p.getAllowedAttributes().stream());
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        if (!customClaims.isEmpty()) {
            Stream.concat(new OidcDiscoveryProperties().getClaims().stream(), customClaims.stream()).collect(Collectors.joining(","));
            properties.put("cas.authn.oidc.discovery.claims", Stream.concat(new OidcDiscoveryProperties().getClaims().stream(), customClaims.stream()).collect(Collectors.joining(",")));
            properties.put("cas.authn.oidc.core.user-defined-scopes.syncope", String.join((CharSequence)",", customClaims));
        }
        ((WAConfigService)syncopeClient.getService(WAConfigService.class)).list().forEach(attr -> properties.put(attr.getSchema(), String.join((CharSequence)",", attr.getValues())));
        LOG.debug("Collected WA properties: {}", properties);
        Map decodedProperties = this.configurationCipher.decode(properties, ArrayUtils.EMPTY_OBJECT_ARRAY);
        LOG.debug("Decoded WA properties: {}", (Object)decodedProperties);
        return new MapPropertySource(this.getClass().getName(), decodedProperties);
    }
}

