/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.webservice;

import org.activiti.engine.impl.bpmn.webservice.MessageDefinition;
import org.activiti.engine.impl.bpmn.webservice.MessageInstance;
import org.activiti.engine.impl.bpmn.webservice.Operation;
import org.activiti.engine.impl.bpmn.webservice.OperationImplementation;
import org.activiti.engine.impl.webservice.WSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSOperation
implements OperationImplementation {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSOperation.class);
    protected String id;
    protected String name;
    protected WSService service;

    public WSOperation(String id, String operationName, WSService service) {
        this.id = id;
        this.name = operationName;
        this.service = service;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MessageInstance sendFor(MessageInstance message, Operation operation) {
        Object[] arguments = this.getArguments(message);
        Object[] results = this.safeSend(arguments);
        return this.createResponseMessage(results, operation);
    }

    private Object[] getArguments(MessageInstance message) {
        return message.getStructureInstance().toArray();
    }

    private Object[] safeSend(Object[] arguments) {
        Object[] results = null;
        try {
            results = this.service.getClient().send(this.name, arguments);
        }
        catch (Exception e) {
            LOGGER.warn("Error calling WS {}", (Object)this.service.getName(), (Object)e);
        }
        if (results == null) {
            results = new Object[]{};
        }
        return results;
    }

    private MessageInstance createResponseMessage(Object[] results, Operation operation) {
        MessageInstance message = null;
        MessageDefinition outMessage = operation.getOutMessage();
        if (outMessage != null) {
            message = outMessage.createInstance();
            message.getStructureInstance().loadFrom(results);
        }
        return message;
    }

    public WSService getService() {
        return this.service;
    }
}

