/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;

public class DiagramInterchangeInfoValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        if (bpmnModel.getLocationMap().size() > 0) {
            for (String bpmnReference : bpmnModel.getLocationMap().keySet()) {
                if (bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (bpmnModel.getArtifact(bpmnReference) != null) continue;
                    this.addWarning(errors, "activiti-di-invalid-reference", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), "Invalid reference in diagram interchange definition: could not find " + bpmnReference);
                    continue;
                }
                if (bpmnModel.getFlowElement(bpmnReference) instanceof FlowNode) continue;
                this.addWarning(errors, "activiti-di-does-not-reference-flownode", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), "Invalid reference in diagram interchange definition: " + bpmnReference + " does not reference a flow node");
            }
        }
        if (bpmnModel.getFlowLocationMap().size() > 0) {
            for (String bpmnReference : bpmnModel.getFlowLocationMap().keySet()) {
                if (bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (bpmnModel.getArtifact(bpmnReference) != null) continue;
                    this.addWarning(errors, "activiti-di-invalid-reference", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), "Invalid reference in diagram interchange definition: could not find " + bpmnReference);
                    continue;
                }
                if (bpmnModel.getFlowElement(bpmnReference) instanceof SequenceFlow) continue;
                if (((List)bpmnModel.getFlowLocationMap().get(bpmnReference)).size() > 0) {
                    this.addWarning(errors, "activiti-di-does-not-reference-seq-flow", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), "Invalid reference in diagram interchange definition: " + bpmnReference + " does not reference a sequence flow");
                    continue;
                }
                this.addWarning(errors, "activiti-di-does-not-reference-seq-flow", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), "Invalid reference in diagram interchange definition: " + bpmnReference + " does not reference a sequence flow");
            }
        }
    }
}

