/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.http;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class PreemptiveAuthHttpRequestFactory
extends HttpComponentsClientHttpRequestFactory {
    private final HttpHost targetHost;

    public PreemptiveAuthHttpRequestFactory(String host, int port, String scheme) {
        this.targetHost = new HttpHost(host, port, scheme);
    }

    public PreemptiveAuthHttpRequestFactory(String host, int port, String scheme, ClientConnectionManager conman, HttpParams params) {
        super((HttpClient)new DefaultHttpClient(conman, params));
        this.targetHost = new HttpHost(host, port, scheme);
    }

    public AuthScope getAuthScope() {
        return new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort(), AuthScope.ANY_REALM, this.targetHost.getSchemeName());
    }

    public AuthScope getLoginAuthScope() {
        return new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort());
    }

    protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
        BasicHttpContext localcontext = new BasicHttpContext();
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.targetHost, (AuthScheme)new BasicScheme());
        localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
        return localcontext;
    }
}

