/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.to;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.common.to.PropagationStatusTO;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlType
public abstract class AbstractAttributableTO
extends ConnObjectTO {
    private static final long serialVersionUID = 4083884098736820255L;
    private long id;
    private List<AttributeTO> derivedAttributes = new ArrayList<AttributeTO>();
    private List<AttributeTO> virtualAttributes = new ArrayList<AttributeTO>();
    private Set<String> resources = new HashSet<String>();
    private final List<PropagationStatusTO> propagationStatusTOs = new ArrayList<PropagationStatusTO>();

    protected AbstractAttributableTO() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @JsonIgnore
    public Map<String, AttributeTO> getDerivedAttributeMap() {
        Map<String, AttributeTO> result;
        if (this.derivedAttributes == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap<String, AttributeTO>(this.derivedAttributes.size());
            for (AttributeTO attributeTO : this.derivedAttributes) {
                result.put(attributeTO.getSchema(), attributeTO);
            }
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    @JsonIgnore
    public Map<String, AttributeTO> getVirtualAttributeMap() {
        Map<String, AttributeTO> result;
        if (this.virtualAttributes == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap<String, AttributeTO>(this.virtualAttributes.size());
            for (AttributeTO attributeTO : this.virtualAttributes) {
                result.put(attributeTO.getSchema(), attributeTO);
            }
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    public boolean addDerivedAttribute(AttributeTO derivedAttribute) {
        return this.derivedAttributes.add(derivedAttribute);
    }

    public boolean removeDerivedAttribute(AttributeTO derivedAttribute) {
        return this.derivedAttributes.remove(derivedAttribute);
    }

    @XmlElementWrapper(name="derivedAttributes")
    @XmlElement(name="attribute")
    public List<AttributeTO> getDerivedAttributes() {
        return this.derivedAttributes;
    }

    public void setDerivedAttributes(List<AttributeTO> derivedAttributes) {
        this.derivedAttributes = derivedAttributes;
    }

    public boolean addVirtualAttribute(AttributeTO virtualAttribute) {
        return this.virtualAttributes.add(virtualAttribute);
    }

    public boolean removeVirtualAttribute(AttributeTO virtualAttribute) {
        return this.virtualAttributes.remove(virtualAttribute);
    }

    @XmlElementWrapper(name="virtualAttributes")
    @XmlElement(name="attribute")
    public List<AttributeTO> getVirtualAttributes() {
        return this.virtualAttributes;
    }

    public void setVirtualAttributes(List<AttributeTO> virtualAttributes) {
        this.virtualAttributes = virtualAttributes;
    }

    public boolean addResource(String resource) {
        return this.resources.add(resource);
    }

    public boolean removeResource(String resource) {
        return this.resources.remove(resource);
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    public Set<String> getResources() {
        return this.resources;
    }

    public void setResources(Set<String> resources) {
        this.resources = resources;
    }

    public boolean addPropagationTO(PropagationStatusTO status) {
        return this.propagationStatusTOs.add(status);
    }

    public boolean removePropagationTO(String resource) {
        if (resource != null && this.getPropagationStatusTOs().isEmpty()) {
            ArrayList<PropagationStatusTO> toBeRemoved = new ArrayList<PropagationStatusTO>();
            for (PropagationStatusTO propagationTO : this.getPropagationStatusTOs()) {
                if (!resource.equals(propagationTO.getResource())) continue;
                toBeRemoved.add(propagationTO);
            }
            return this.propagationStatusTOs.removeAll(toBeRemoved);
        }
        return false;
    }

    @XmlElementWrapper(name="propagationStatuses")
    @XmlElement(name="propagationStatus")
    public List<PropagationStatusTO> getPropagationStatusTOs() {
        return this.propagationStatusTOs;
    }

    public void setPropagationStatusTOs(List<PropagationStatusTO> propagationStatusTOs) {
        if (this.propagationStatusTOs != propagationStatusTOs) {
            this.propagationStatusTOs.clear();
            this.propagationStatusTOs.addAll(propagationStatusTOs);
        }
    }
}

