/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import org.apache.wicket.util.lang.Args;

public final class Cookies {
    private Cookies() {
    }

    public static Cookie copyOf(Cookie cookie) {
        return cookie != null ? (Cookie)cookie.clone() : null;
    }

    public static Key keyOf(Cookie cookie) {
        return new Key(cookie);
    }

    public static boolean isEqual(Cookie c1, Cookie c2) {
        Args.notNull((Object)c1, (String)"c1");
        Args.notNull((Object)c2, (String)"c2");
        return new Key(c1).equals(new Key(c2));
    }

    public static boolean isExpired(Cookie cookie) {
        return cookie.getMaxAge() == 0;
    }

    public static class Key
    implements Serializable {
        private final String name;
        private final String path;
        private final String domain;

        protected Key(Cookie cookie) {
            Args.notNull((Object)cookie, (String)"cookie");
            this.name = cookie.getName();
            this.path = cookie.getPath();
            this.domain = cookie.getDomain();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            return this.name + ";" + this.domain + "/" + this.path;
        }
    }
}

